"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Arg = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = require("react");
var _arg_form = require("../components/arg_form");
var _arg_type_registry = require("./arg_type_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error unconverted components

class Arg {
  constructor(props) {
    (0, _defineProperty2.default)(this, "argType", void 0);
    (0, _defineProperty2.default)(this, "multi", void 0);
    (0, _defineProperty2.default)(this, "required", void 0);
    (0, _defineProperty2.default)(this, "types", void 0);
    (0, _defineProperty2.default)(this, "default", void 0);
    (0, _defineProperty2.default)(this, "resolve", void 0);
    (0, _defineProperty2.default)(this, "options", void 0);
    (0, _defineProperty2.default)(this, "name", '');
    (0, _defineProperty2.default)(this, "displayName", void 0);
    (0, _defineProperty2.default)(this, "help", void 0);
    const argType = _arg_type_registry.argTypeRegistry.get(props.argType);
    if (!argType) {
      throw new Error(`Invalid arg type: ${props.argType}`);
    }
    if (!props.name) {
      throw new Error('Args must have a name property');
    }

    // properties that can be overridden
    const defaultProps = {
      multi: false,
      required: false,
      types: [],
      default: argType.default != null ? argType.default : null,
      options: {},
      resolve: () => ({})
    };
    const {
      name,
      displayName,
      help,
      multi,
      types,
      options
    } = props;
    (0, _lodash.merge)(this, defaultProps, argType, {
      argType,
      name,
      displayName,
      help,
      multi,
      types,
      default: props.default,
      resolve: props.resolve,
      required: props.required,
      options
    });
  }

  // TODO: Document what these otherProps are. Maybe make them named arguments?
  render(data) {
    var _this$resolve;
    const {
      onValueChange,
      onValueRemove,
      key,
      label,
      ...otherProps
    } = data;
    const resolvedProps = (_this$resolve = this.resolve) === null || _this$resolve === void 0 ? void 0 : _this$resolve.call(this, otherProps);
    const {
      argValue,
      onAssetAdd,
      resolved,
      filterGroups,
      argResolver
    } = otherProps;
    const argId = key;
    // This is everything the arg_type template needs to render
    const templateProps = {
      argValue,
      argId,
      onAssetAdd,
      onValueChange,
      typeInstance: this,
      resolved: {
        ...resolved,
        ...resolvedProps
      },
      argResolver,
      filterGroups
    };
    const formProps = {
      key,
      argTypeInstance: this,
      valueMissing: this.required && data.argValue == null,
      label,
      onValueChange,
      onValueRemove,
      templateProps,
      argId,
      options: this.options
    };
    return /*#__PURE__*/(0, _react.createElement)(_arg_form.ArgForm, formProps);
  }
}
exports.Arg = Arg;