"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareWebsiteFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _workpad = require("../../../../state/selectors/workpad");
var _flyout = require("./flyout.component");
var _supported_renderers = require("../../../../../shareable_runtime/supported_renderers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @kbn/imports/no_boundary_crossing

const getUnsupportedRenderers = state => {
  const renderers = [];
  const expressions = (0, _workpad.getRenderedWorkpadExpressions)(state);
  expressions.forEach(expression => {
    if (!_supported_renderers.renderFunctionNames.includes(expression)) {
      renderers.push(expression);
    }
  });
  return renderers;
};
const ShareWebsiteFlyout = ({
  onClose
}) => {
  const {
    renderedWorkpad,
    unsupportedRenderers
  } = (0, _reactRedux.useSelector)(state => ({
    renderedWorkpad: (0, _workpad.getRenderedWorkpad)(state),
    unsupportedRenderers: getUnsupportedRenderers(state),
    workpad: (0, _workpad.getWorkpad)(state)
  }));
  return /*#__PURE__*/_react.default.createElement(_flyout.ShareWebsiteFlyout, {
    onClose: onClose,
    unsupportedRenderers: unsupportedRenderers,
    renderedWorkpad: renderedWorkpad
  });
};
exports.ShareWebsiteFlyout = ShareWebsiteFlyout;