"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _reactShortcuts = require("react-shortcuts");
var _expression_input = require("../expression_input");
var _tool_tip_shortcut = require("../tool_tip_shortcut");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const strings = {
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getCloseButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  getLearnLinkText: () => _i18n.i18n.translate('xpack.canvas.expression.learnLinkText', {
    defaultMessage: 'Learn expression syntax'
  }),
  getMaximizeButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.maximizeButtonLabel', {
    defaultMessage: 'Maximize editor'
  }),
  getMinimizeButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.minimizeButtonLabel', {
    defaultMessage: 'Minimize Editor'
  }),
  getRunButtonLabel: () => _i18n.i18n.translate('xpack.canvas.expression.runButtonLabel', {
    defaultMessage: 'Run'
  }),
  getRunTooltip: () => _i18n.i18n.translate('xpack.canvas.expression.runTooltip', {
    defaultMessage: 'Run the expression'
  })
};
const shortcut = (ref, cmd, callback) => /*#__PURE__*/_react.default.createElement(_reactShortcuts.Shortcuts, {
  name: "EXPRESSION",
  handler: command => {
    const isInputActive = ref.current && ref.current && ref.current.hasTextFocus();
    if (isInputActive && command === cmd) {
      callback();
    }
  },
  targetNodeSelector: "body",
  global: true,
  stopPropagation: true
});
const Expression = ({
  functionDefinitions,
  formState,
  updateValue,
  setExpression,
  done,
  error,
  isCompact,
  toggleCompactView
}) => {
  const refExpressionInput = (0, _react.useRef)(null);
  const handleRun = () => {
    setExpression(formState.expression);
    // If fullScreen and you hit run, toggle back down so you can see your work
    if (!isCompact && !error) {
      toggleCompactView();
    }
  };
  const onEditorDidMount = editor => {
    /*
      To enable the CMD+ENTER keybinding, which is running the expression,
      it is necessary to disable the `-editor.action.insertLineAfter`,
      which has the same keybinding in the Monaco editor.
      The only available way is adding the empty dynamic keybinding
      (by using private monaco API, proposed by the monaco team), which is bubbling the event.
    */
    // @ts-expect-error
    editor === null || editor === void 0 ? void 0 : editor._standaloneKeybindingService.addDynamicKeybinding('-editor.action.insertLineAfter',
    // eslint-disable-next-line no-bitwise
    _monaco.monaco.KeyMod.CtrlCmd | _monaco.monaco.KeyCode.Enter, () => {});
  };
  const expressionPanel = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: `canvasTray__panel canvasTray__panel--holdingExpression canvasExpression--${isCompact ? 'compactSize' : 'fullSize'}`,
    paddingSize: "none"
  }, shortcut(refExpressionInput, 'RUN', () => {
    if (!error) {
      setExpression(formState.expression);
    }
  }), /*#__PURE__*/_react.default.createElement(_expression_input.ExpressionInput, {
    isCompact: isCompact,
    expressionFunctions: functionDefinitions,
    error: error ? error : `\u00A0`,
    expression: formState.expression,
    onChange: updateValue,
    onEditorDidMount: onEditorDidMount,
    editorRef: refExpressionInput
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExpression__settings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement("span", null, strings.getRunTooltip(), ' ', /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "EXPRESSION",
      action: "RUN"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !!error,
    onClick: handleRun,
    size: "s"
  }, strings.getRunButtonLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: formState.dirty ? 'danger' : 'primary',
    onClick: done
  }, formState.dirty ? strings.getCancelButtonLabel() : strings.getCloseButtonLabel())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/guide/en/kibana/current/canvas-function-reference.html",
    target: "_blank"
  }, strings.getLearnLinkText())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "fullScreen",
    onClick: toggleCompactView,
    size: "s"
  }, isCompact ? strings.getMaximizeButtonLabel() : strings.getMinimizeButtonLabel())))))));
  if (isCompact) {
    return expressionPanel;
  } else {
    // Portal is required to show above the navigation
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, expressionPanel);
  }
};
exports.Expression = Expression;
Expression.propTypes = {
  functionDefinitions: _propTypes.default.array,
  formState: _propTypes.default.object,
  updateValue: _propTypes.default.func,
  setExpression: _propTypes.default.func,
  done: _propTypes.default.func,
  error: _propTypes.default.string
};