"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEmbeddableFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _services = require("../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getNoItemsText: () => _i18n.i18n.translate('xpack.canvas.embedObject.noMatchingObjectsMessage', {
    defaultMessage: 'No matching objects found.'
  }),
  getTitleText: () => _i18n.i18n.translate('xpack.canvas.embedObject.titleText', {
    defaultMessage: 'Add from library'
  })
};
const AddEmbeddableFlyout = ({
  onSelect,
  availableEmbeddables,
  onClose,
  isByValueEnabled
}) => {
  const embeddablesService = (0, _services.useEmbeddablesService)();
  const platformService = (0, _services.usePlatformService)();
  const {
    getEmbeddableFactories
  } = embeddablesService;
  const {
    getHttp,
    getUISettings,
    getSavedObjectsManagement
  } = platformService;
  const onAddPanel = (0, _react.useCallback)((id, savedObjectType) => {
    const embeddableFactories = getEmbeddableFactories();
    // Find the embeddable type from the saved object type
    const found = Array.from(embeddableFactories).find(embeddableFactory => {
      return Boolean(embeddableFactory.savedObjectMetaData && embeddableFactory.savedObjectMetaData.type === savedObjectType);
    });
    const foundEmbeddableType = found ? found.type : 'unknown';
    onSelect(id, foundEmbeddableType, isByValueEnabled);
  }, [isByValueEnabled, getEmbeddableFactories, onSelect]);
  const embeddableFactories = getEmbeddableFactories();
  const availableSavedObjects = Array.from(embeddableFactories).filter(factory => isByValueEnabled || availableEmbeddables.includes(factory.type)).map(factory => factory.savedObjectMetaData).filter(function (maybeSavedObjectMetaData) {
    return maybeSavedObjectMetaData !== undefined;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "dashboardAddPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, strings.getTitleText()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    onChoose: onAddPanel,
    savedObjectMetaData: availableSavedObjects,
    showFilter: true,
    noItemsMessage: strings.getNoItemsText(),
    services: {
      uiSettings: getUISettings(),
      http: getHttp(),
      savedObjectsManagement: getSavedObjectsManagement()
    }
  })));
};
exports.AddEmbeddableFlyout = AddEmbeddableFlyout;