"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _interpreter = require("@kbn/interpreter");
var _loading = require("../loading");
var _render_with_fn = require("../render_with_fn");
var _element_share_container = require("../element_share_container");
var _invalid_expression = require("./invalid_expression");
var _invalid_element_type = require("./invalid_element_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error Untyped local

const ElementContent = props => {
  const {
    renderable,
    renderFunction,
    width,
    height,
    handlers,
    backgroundColor,
    state
  } = props;
  const {
    onComplete
  } = handlers;
  if (!state || !renderable) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      backgroundColor: backgroundColor
    });
  }

  // renderable is available, but no matching element is found, render invalid
  if (renderable && (0, _interpreter.getType)(renderable) !== 'render' && !renderFunction) {
    return /*#__PURE__*/_react.default.createElement(_invalid_element_type.InvalidElementType, (0, _extends2.default)({}, props, {
      renderableType: renderable === null || renderable === void 0 ? void 0 : renderable.as
    }));
  }

  // error state, render invalid expression notice
  if (state === 'error' ||
  // The renderable has an error
  (0, _interpreter.getType)(renderable) !== 'render' ||
  // The renderable isn't, well, renderable
  !renderFunction // We can't find an element in the registry for this
  ) {
    return /*#__PURE__*/_react.default.createElement(_invalid_expression.InvalidExpression, props);
  }
  const containerStyle = (0, _lodash.omitBy)(renderable.containerStyle, _lodash.isNil);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)(renderable.css)
    // TODO: 'canvas__element' was added for BWC, It can be removed after a while
    ,
    className: 'canvas__element canvasElement',
    style: {
      ...containerStyle,
      width,
      height
    },
    "data-test-subj": "canvasWorkpadPageElementContent"
  }, /*#__PURE__*/_react.default.createElement(_element_share_container.ElementShareContainer, {
    className: "canvasElement__content",
    onComplete: onComplete,
    functionName: renderFunction.name
  }, /*#__PURE__*/_react.default.createElement(_render_with_fn.RenderWithFn, {
    name: renderFunction.name,
    renderFn: renderFunction.render,
    reuseNode: renderFunction.reuseDomNode,
    config: renderable.value,
    width: width,
    height: height,
    handlers: handlers
  })));
};
exports.ElementContent = ElementContent;