"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Datasource = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _expression_types = require("../../expression_types");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _elements = require("../../state/actions/elements");
var _datasource = require("./datasource");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasourceComponent = props => {
  const {
    args,
    datasource
  } = props;
  const [stateArgs, updateArgs] = (0, _react.useState)(args);
  const [selecting, setSelecting] = (0, _react.useState)(false);
  const [previewing, setPreviewing] = (0, _react.useState)(false);
  const [isInvalid, setInvalid] = (0, _react.useState)(false);
  const [stateDatasource, selectDatasource] = (0, _react.useState)(datasource);
  const resetArgs = (0, _react.useCallback)(() => {
    updateArgs(args);
  }, [updateArgs, args]);
  return /*#__PURE__*/_react.default.createElement(_datasource.Datasource, (0, _extends2.default)({}, props, {
    stateArgs: stateArgs,
    updateArgs: updateArgs,
    selecting: selecting,
    setSelecting: setSelecting,
    previewing: previewing,
    setPreviewing: setPreviewing,
    isInvalid: isInvalid,
    setInvalid: setInvalid,
    stateDatasource: stateDatasource,
    selectDatasource: selectDatasource,
    resetArgs: resetArgs
  }));
};
const mapStateToProps = state => ({
  element: (0, _workpad.getSelectedElement)(state),
  pageId: (0, _workpad.getSelectedPage)(state),
  functionDefinitions: (0, _app.getServerFunctions)(state)
});
const mapDispatchToProps = dispatch => ({
  dispatchAstAtIndex: ({
    index,
    element,
    pageId
  }) => ast => {
    dispatch((0, _elements.flushContext)(element.id));
    dispatch((0, _elements.setAstAtIndex)(index, ast, element, pageId));
  }
});
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    element,
    pageId,
    functionDefinitions
  } = stateProps;
  const {
    dispatchAstAtIndex
  } = dispatchProps;
  const getDataTableFunctionsByName = name => functionDefinitions.find(fn => fn.name === name && fn.type === 'datatable');

  // find the matching datasource from the expression AST
  const datasourceAst = (0, _lodash.get)(element, 'ast.chain', []).map((astDef, i) => {
    // if it's not a function, it's can't be a datasource
    if (astDef.type !== 'function') {
      return;
    }
    const args = astDef.arguments;

    // if there's no matching datasource in the registry, we're done
    const datasource = _expression_types.datasourceRegistry.get(astDef.function);
    if (!datasource) {
      return;
    }
    const datasourceDef = getDataTableFunctionsByName(datasource.name);

    // keep track of the ast, the ast index2, and the datasource
    return {
      datasource,
      datasourceDef,
      args,
      expressionIndex: i
    };
  }).filter(Boolean)[0];
  return {
    ...ownProps,
    ...stateProps,
    ...dispatchProps,
    ...datasourceAst,
    datasources: _expression_types.datasourceRegistry.toArray(),
    setDatasourceAst: dispatchAstAtIndex({
      pageId,
      element,
      index: datasourceAst && datasourceAst.expressionIndex
    })
  };
};
const Datasource = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(DatasourceComponent);
exports.Datasource = Datasource;
Datasource.propTypes = {
  done: _propTypes.PropTypes.func
};