"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourceComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _datasource_selector = require("./datasource_selector");
var _datasource_preview = require("./datasource_preview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getExpressionArgDescription: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourceComponent.expressionArgDescription', {
    defaultMessage: 'The datasource has an argument controlled by an expression. Use the expression editor to modify the datasource.'
  }),
  getPreviewButtonLabel: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourceComponent.previewButtonLabel', {
    defaultMessage: 'Preview data'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourceComponent.saveButtonLabel', {
    defaultMessage: 'Save'
  })
};
class DatasourceComponent extends _react.PureComponent {
  constructor(..._args) {
    super(..._args);
    (0, _defineProperty2.default)(this, "state", {
      defaultIndex: ''
    });
    (0, _defineProperty2.default)(this, "getDatasourceFunctionNode", (name, args) => ({
      arguments: args,
      function: name,
      type: 'function'
    }));
    (0, _defineProperty2.default)(this, "setSelectedDatasource", value => {
      const {
        datasource,
        resetArgs,
        updateArgs,
        selectDatasource,
        datasources,
        setSelecting
      } = this.props;
      if (datasource.name === value) {
        // if selecting the current datasource, reset the arguments
        resetArgs && resetArgs();
      } else {
        // otherwise, clear the arguments, the form will update them
        updateArgs && updateArgs({});
      }
      selectDatasource && selectDatasource(datasources.find(d => d.name === value));
      setSelecting(false);
    });
    (0, _defineProperty2.default)(this, "save", () => {
      const {
        stateDatasource,
        stateArgs,
        setDatasourceAst
      } = this.props;
      const datasourceAst = this.getDatasourceFunctionNode(stateDatasource.name, stateArgs);
      setDatasourceAst && setDatasourceAst(datasourceAst);
    });
  }
  componentDidMount() {
    _services.pluginServices.getServices().dataViews.getDefaultDataView().then(defaultDataView => {
      this.setState({
        defaultIndex: defaultDataView.title
      });
    });
  }
  componentDidUpdate(prevProps) {
    const {
      args,
      resetArgs,
      datasource,
      selectDatasource
    } = this.props;
    if (!(0, _lodash.isEqual)(prevProps.args, args)) {
      resetArgs();
    }
    if (!(0, _lodash.isEqual)(prevProps.datasource, datasource)) {
      selectDatasource(datasource);
    }
  }
  render() {
    const {
      datasources,
      datasourceDef,
      stateDatasource,
      stateArgs,
      updateArgs,
      selecting,
      setSelecting,
      previewing,
      setPreviewing,
      isInvalid,
      setInvalid,
      renderError
    } = this.props;
    const {
      defaultIndex
    } = this.state;
    if (selecting) {
      return /*#__PURE__*/_react.default.createElement(_datasource_selector.DatasourceSelector, {
        datasources: datasources,
        onSelect: this.setSelectedDatasource,
        current: stateDatasource.name
      });
    }
    const datasourcePreview = previewing ? /*#__PURE__*/_react.default.createElement(_datasource_preview.DatasourcePreview, {
      show: previewing,
      done: () => setPreviewing(false),
      function: this.getDatasourceFunctionNode(stateDatasource.name, stateArgs)
    }) : null;
    const datasourceRender = () => stateDatasource.render({
      args: stateArgs,
      updateArgs,
      datasourceDef,
      isInvalid,
      setInvalid,
      defaultIndex,
      renderError
    });
    const hasExpressionArgs = Object.values(stateArgs).some(a => a && typeof a[0] === 'object');
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasDataSource__section"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconSide: "right",
      iconType: "arrowRight",
      onClick: () => setSelecting(!selecting),
      className: "canvasDataSource__triggerButton",
      flush: "left",
      size: "s",
      "data-test-subj": "canvasChangeDatasourceButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: stateDatasource.image,
      className: "canvasDataSource__triggerButtonIcon"
    }), stateDatasource.displayName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), !hasExpressionArgs ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, datasourceRender(), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: () => setPreviewing(true)
    }, strings.getPreviewButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: isInvalid,
      size: "s",
      onClick: this.save,
      fill: true,
      color: "success",
      "data-test-subj": "canvasSaveDatasourceButton"
    }, strings.getSaveButtonLabel())))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, strings.getExpressionArgDescription()))), datasourcePreview);
  }
}
exports.DatasourceComponent = DatasourceComponent;
(0, _defineProperty2.default)(DatasourceComponent, "propTypes", {
  args: _propTypes.default.object.isRequired,
  datasources: _propTypes.default.array.isRequired,
  datasource: _propTypes.default.object.isRequired,
  datasourceDef: _propTypes.default.object.isRequired,
  stateDatasource: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    render: _propTypes.default.func.isRequired
  }).isRequired,
  selectDatasource: _propTypes.default.func,
  setDatasourceAst: _propTypes.default.func,
  stateArgs: _propTypes.default.object.isRequired,
  updateArgs: _propTypes.default.func,
  resetArgs: _propTypes.default.func.isRequired,
  selecting: _propTypes.default.bool,
  setSelecting: _propTypes.default.func,
  previewing: _propTypes.default.bool,
  setPreviewing: _propTypes.default.func,
  isInvalid: _propTypes.default.bool,
  setInvalid: _propTypes.default.func,
  renderError: _propTypes.default.func
});