"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedFailure = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _interpreter = require("@kbn/interpreter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getApplyButtonLabel: () => _i18n.i18n.translate('xpack.canvas.argFormAdvancedFailure.applyButtonLabel', {
    defaultMessage: 'Apply'
  }),
  getResetButtonLabel: () => _i18n.i18n.translate('xpack.canvas.argFormAdvancedFailure.resetButtonLabel', {
    defaultMessage: 'Reset'
  }),
  getRowErrorMessage: () => _i18n.i18n.translate('xpack.canvas.argFormAdvancedFailure.rowErrorMessage', {
    defaultMessage: 'Invalid Expression'
  })
};
const isValid = argExpression => {
  try {
    (0, _interpreter.fromExpression)(argExpression, 'argument');
    return true;
  } catch (e) {
    return false;
  }
};
const AdvancedFailure = props => {
  const {
    onValueChange,
    defaultValue,
    argValue,
    resetErrorState,
    argId
  } = props;
  const [argExpression, setArgExpression] = (0, _react.useState)((0, _interpreter.toExpression)(argValue, 'argument'));
  const [valid, setValid] = (0, _react.useState)(isValid(argExpression));
  (0, _react.useEffect)(() => {
    const argExpr = (0, _interpreter.toExpression)(argValue, 'argument');
    setArgExpression(argExpr);
    setValid(isValid(argExpr));
  }, [argValue]);
  const valueChange = ev => {
    ev.preventDefault();
    resetErrorState(); // when setting a new value, attempt to reset the error state
    if (valid) {
      return onValueChange((0, _interpreter.fromExpression)(argExpression.trim(), 'argument'));
    }
  };
  const confirmReset = ev => {
    ev.preventDefault();
    resetErrorState(); // when setting a new value, attempt to reset the error state
    onValueChange((0, _interpreter.fromExpression)(defaultValue, 'argument'));
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    id: argId,
    isInvalid: !valid,
    error: strings.getRowErrorMessage()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    id: argId,
    isInvalid: !valid,
    value: argExpression,
    compressed: true,
    onChange: ev => setArgExpression(ev.target.value),
    rows: 3
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !valid,
    onClick: e => valueChange(e),
    size: "s",
    type: "submit"
  }, strings.getApplyButtonLabel()), defaultValue && defaultValue.length && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "danger",
    onClick: confirmReset
  }, strings.getResetButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.AdvancedFailure = AdvancedFailure;
AdvancedFailure.propTypes = {
  defaultValue: _propTypes.default.string,
  onValueChange: _propTypes.default.func.isRequired,
  resetErrorState: _propTypes.default.func.isRequired,
  argId: _propTypes.default.string.isRequired,
  argValue: _propTypes.default.any.isRequired
};