"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeAssets = writeAssets;
var _debug_log = require("../../common/debug_log");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function writeAssets({
  esClient,
  assetDocs,
  namespace = 'default',
  refresh = false
}) {
  const dsl = {
    refresh,
    operations: assetDocs.flatMap(asset => [{
      create: {
        _index: `${_constants.ASSETS_INDEX_PREFIX}-${asset['asset.type']}-${namespace}`
      }
    }, asset])
  };
  (0, _debug_log.debug)('Performing Write Asset Query', '\n\n', JSON.stringify(dsl, null, 2));
  return await esClient.bulk(dsl);
}