"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssets = getAssets;
var _debug_log = require("../../common/debug_log");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAssets({
  esClient,
  size = 100,
  filters = {}
}) {
  // Maybe it makes the most sense to validate the filters here?

  const {
    from = 'now-24h',
    to = 'now'
  } = filters;
  const must = [];
  if (filters && Object.keys(filters).length > 0) {
    var _filters$type;
    if (typeof filters.collectionVersion === 'number') {
      must.push({
        term: {
          ['asset.collection_version']: filters.collectionVersion
        }
      });
    }
    if ((_filters$type = filters.type) !== null && _filters$type !== void 0 && _filters$type.length) {
      must.push({
        terms: {
          ['asset.type']: Array.isArray(filters.type) ? filters.type : [filters.type]
        }
      });
    }
    if (filters.kind) {
      must.push({
        term: {
          ['asset.kind']: filters.kind
        }
      });
    }
    if (filters.ean) {
      must.push({
        terms: {
          ['asset.ean']: Array.isArray(filters.ean) ? filters.ean : [filters.ean]
        }
      });
    }
    if (filters.id) {
      must.push({
        term: {
          ['asset.id']: filters.id
        }
      });
    }
    if (filters.typeLike) {
      must.push({
        wildcard: {
          ['asset.type']: filters.typeLike
        }
      });
    }
    if (filters.eanLike) {
      must.push({
        wildcard: {
          ['asset.ean']: filters.eanLike
        }
      });
    }
  }
  const dsl = {
    index: _constants.ASSETS_INDEX_PREFIX + '*',
    size,
    query: {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }],
        must
      }
    },
    collapse: {
      field: 'asset.ean'
    },
    sort: {
      '@timestamp': {
        order: 'desc'
      }
    }
  };
  (0, _debug_log.debug)('Performing Asset Query', '\n\n', JSON.stringify(dsl, null, 2));
  const response = await esClient.search(dsl);
  return response.hits.hits.map(hit => hit._source).filter(asset => !!asset);
}