"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHealthStatuses = getHealthStatuses;
var _anomaly_detection = require("../../../../common/anomaly_detection");
var _service_health_status = require("../../../../common/service_health_status");
var _get_service_anomalies = require("../../service_map/get_service_anomalies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHealthStatuses({
  environment,
  mlClient,
  start,
  end
}) {
  if (!mlClient) {
    return [];
  }
  const anomalies = await (0, _get_service_anomalies.getServiceAnomalies)({
    mlClient,
    environment,
    start,
    end
  });
  return anomalies.serviceAnomalies.map(anomalyStats => {
    const severity = (0, _anomaly_detection.getSeverity)(anomalyStats.anomalyScore);
    const healthStatus = (0, _service_health_status.getServiceHealthStatus)({
      severity
    });
    return {
      serviceName: anomalyStats.serviceName,
      healthStatus
    };
  });
}