"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handle403Exception = handle403Exception;
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handle403Exception(promise, defaultValue) {
  try {
    return await promise;
  } catch (error) {
    if (error instanceof _elasticsearch.errors.ResponseError && error.meta.statusCode === 403) {
      console.error(`Suppressed insufficient access error: ${error.message}}`);
      return defaultValue;
    }
    console.error(`Unhandled error: ${error.message} ${JSON.stringify(error)}}`);
    throw error;
  }
}