"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionTraceSamplesFetcher = useTransactionTraceSamplesFetcher;
var _react = require("react");
var _use_fetcher = require("./use_fetcher");
var _use_url_params = require("../context/url_params_context/use_url_params");
var _use_apm_service_context = require("../context/apm_service/use_apm_service_context");
var _use_apm_params = require("./use_apm_params");
var _use_time_range = require("./use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTransactionTraceSamplesFetcher({
  transactionName,
  kuery,
  environment
}) {
  const {
    serviceName,
    transactionType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    urlParams: {
      transactionId,
      traceId,
      sampleRangeFrom,
      sampleRangeTo
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end && transactionType && transactionName) {
      return callApmApi('GET /internal/apm/services/{serviceName}/transactions/traces/samples', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            transactionType,
            transactionName,
            transactionId,
            traceId,
            sampleRangeFrom,
            sampleRangeTo
          }
        }
      });
    }
  },
  // the samples should not be refetched if the transactionId or traceId changes
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, serviceName, start, end, transactionType, transactionName, sampleRangeFrom, sampleRangeTo]);
  return (0, _react.useMemo)(() => ({
    data,
    status,
    error
  }), [data, status, error]);
}