"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartPointerEventContext = useChartPointerEventContext;
var _react = _interopRequireWildcard(require("react"));
var _chart_pointer_event_context = require("./chart_pointer_event_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useChartPointerEventContext() {
  const context = (0, _react.useContext)(_chart_pointer_event_context.ChartPointerEventContext);
  if (!context) {
    throw new Error('Missing ChartPointerEventContext provider');
  }
  const {
    pointerEventTargetRef
  } = context;
  const chartRef = /*#__PURE__*/_react.default.createRef();
  const requestIdRef = (0, _react.useRef)(0);
  const updatePointerEventHandler = (0, _react.useCallback)(event => {
    cancelAnimationFrame(requestIdRef.current);
    requestIdRef.current = requestAnimationFrame(() => {
      const pointerEvent = event instanceof CustomEvent ? event.detail : null;
      if (chartRef.current && pointerEvent) {
        chartRef.current.dispatchExternalPointerEvent(pointerEvent);
      }
    });
  }, [chartRef]);
  (0, _react.useEffect)(() => {
    const pointerEventTarget = pointerEventTargetRef.current;
    pointerEventTarget.addEventListener(_chart_pointer_event_context.UPDATE_POINTER_EVENT, updatePointerEventHandler);
    return () => {
      pointerEventTarget.removeEventListener(_chart_pointer_event_context.UPDATE_POINTER_EVENT, updatePointerEventHandler);
    };
  }, [updatePointerEventHandler, pointerEventTargetRef]);
  return {
    ...context,
    chartRef
  };
}