"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceNodeMetricOverviewLink = ServiceNodeMetricOverviewLink;
exports.useServiceNodeMetricOverviewHref = useServiceNodeMetricOverviewHref;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _apm_link = require("./apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistedFilters = ['host', 'containerId', 'podName', 'serviceVersion'];
function useServiceNodeMetricOverviewHref({
  serviceName,
  serviceNodeName
}) {
  return (0, _apm_link.useAPMHref)({
    path: `/services/${serviceName}/metrics/${encodeURIComponent(serviceNodeName)}`,
    persistedFilters
  });
}
function ServiceNodeMetricOverviewLink({
  serviceName,
  serviceNodeName,
  ...rest
}) {
  const href = useServiceNodeMetricOverviewHref({
    serviceName,
    serviceNodeName
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmServiceNodeMetricOverviewLinkLink",
    href: href
  }, rest));
}