"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionCharts = TransactionCharts;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _annotations_context = require("../../../../context/annotations/annotations_context");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _service_overview_throughput_chart = require("../../../app/service_overview/service_overview_throughput_chart");
var _latency_chart = require("../latency_chart");
var _transaction_breakdown_chart = require("../transaction_breakdown_chart");
var _transaction_coldstart_rate_chart = require("../transaction_coldstart_rate_chart");
var _failed_transaction_rate_chart = require("../failed_transaction_rate_chart");
var _top_errors = require("../../../app/transaction_details/top_errors");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionCharts({
  kuery,
  environment,
  start,
  end,
  serviceName,
  transactionName,
  isServerlessContext,
  comparisonEnabled,
  offset
}) {
  // The default EuiFlexGroup breaks at 768, but we want to break at 1200
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const rowDirection = isLarge ? 'column' : 'row';
  const latencyChart = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-cy": `transaction-duration-charts`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    kuery: kuery
  })));
  const serviceOverviewThroughputChart = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      flexShrink: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    kuery: kuery,
    transactionName: transactionName
  }));
  const coldStartRateOrBreakdownChart = isServerlessContext ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_transaction_coldstart_rate_chart.TransactionColdstartRateChart, {
    kuery: kuery,
    transactionName: transactionName,
    environment: environment,
    comparisonEnabled: comparisonEnabled,
    offset: offset
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_transaction_breakdown_chart.TransactionBreakdownChart, {
    kuery: kuery,
    environment: environment
  }));
  const failedTransactionRateChart = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    kuery: kuery
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, transactionName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: "s"
  }, latencyChart, serviceOverviewThroughputChart, coldStartRateOrBreakdownChart), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false
  }, failedTransactionRateChart, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_top_errors.TopErrors, null))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, latencyChart, serviceOverviewThroughputChart), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, failedTransactionRateChart, coldStartRateOrBreakdownChart)))));
}