"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMarker = ErrorMarker;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _apm = require("../../../../../../common/es_fields/apm");
var _formatters = require("../../../../../../common/utils/formatters");
var _use_url_params = require("../../../../../context/url_params_context/use_url_params");
var _use_theme = require("../../../../../hooks/use_theme");
var _error_detail_link = require("../../../links/apm/error_detail_link");
var _legend = require("../legend");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Popover = _common.euiStyled.div`
  max-width: 280px;
`;
const TimeLegend = (0, _common.euiStyled)(_legend.Legend)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSize};
`;
const ErrorLink = (0, _common.euiStyled)(_error_detail_link.ErrorDetailLink)`
  display: block;
  margin: ${({
  theme
}) => `${theme.eui.euiSizeS} 0 ${theme.eui.euiSizeS} 0`};
  overflow-wrap: break-word;
`;
const Button = (0, _common.euiStyled)(_legend.Legend)`
  height: 20px;
  display: flex;
  align-items: flex-end;
`;

// We chose 240 characters because it fits most error messages and it's still easily readable on a screen.
function truncateMessage(errorMessage) {
  const maxLength = 240;
  if (typeof errorMessage === 'string' && errorMessage.length > maxLength) {
    return errorMessage.substring(0, maxLength) + '…';
  } else {
    return errorMessage;
  }
}
function ErrorMarker({
  mark
}) {
  var _error$trace, _error$trace2, _error$transaction, _error$transaction2, _error$error$log, _error$error$exceptio, _error$error$exceptio2;
  const theme = (0, _use_theme.useTheme)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const [isPopoverOpen, showPopover] = (0, _react.useState)(false);
  const togglePopover = () => showPopover(!isPopoverOpen);
  const button = /*#__PURE__*/_react.default.createElement(Button, {
    "data-test-subj": "popover",
    clickable: true,
    color: theme.eui.euiColorDanger,
    shape: _legend.Shape.square,
    onClick: togglePopover
  });
  const {
    error
  } = mark;
  const {
    rangeTo,
    rangeFrom
  } = urlParams;
  const query = {
    kuery: [...((_error$trace = error.trace) !== null && _error$trace !== void 0 && _error$trace.id ? [`${_apm.TRACE_ID} : "${(_error$trace2 = error.trace) === null || _error$trace2 === void 0 ? void 0 : _error$trace2.id}"`] : []), ...((_error$transaction = error.transaction) !== null && _error$transaction !== void 0 && _error$transaction.id ? [`${_apm.TRANSACTION_ID} : "${(_error$transaction2 = error.transaction) === null || _error$transaction2 === void 0 ? void 0 : _error$transaction2.id}"`] : [])].join(' and '),
    rangeFrom,
    rangeTo
  };
  const errorMessage = ((_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.message) || ((_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : (_error$error$exceptio2 = _error$error$exceptio[0]) === null || _error$error$exceptio2 === void 0 ? void 0 : _error$error$exceptio2.message);
  const truncatedErrorMessage = truncateMessage(errorMessage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(Popover, null, /*#__PURE__*/_react.default.createElement(TimeLegend, {
    text: (0, _formatters.asDuration)(mark.offset),
    indicator: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        marginRight: theme.eui.euiSizeXS
      }
    }, "@")
  }), /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    key: mark.serviceColor,
    color: mark.serviceColor,
    text: error.service.name,
    indicator: /*#__PURE__*/_react.default.createElement("span", null)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(ErrorLink, {
    "data-test-subj": "errorLink",
    serviceName: error.service.name,
    errorGroupId: error.error.grouping_key,
    query: query,
    title: errorMessage
  }, truncatedErrorMessage))));
}