"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmServiceTemplate = ApmServiceTemplate;
exports.isInfraTabHidden = isInfraTabHidden;
exports.isMetricsTabHidden = isMetricsTabHidden;
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../../common/agent_name");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _apm_service_context = require("../../../../context/apm_service/apm_service_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _service_anomaly_timeseries_context = require("../../../../context/service_anomaly_timeseries/service_anomaly_timeseries_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _get_alerting_capabilities = require("../../../alerting/utils/get_alerting_capabilities");
var _beta_badge = require("../../../shared/beta_badge");
var _url_helpers = require("../../../shared/links/url_helpers");
var _search_bar = require("../../../shared/search_bar/search_bar");
var _service_icons = require("../../../shared/service_icons");
var _technical_preview_badge = require("../../../shared/technical_preview_badge");
var _apm_main_template = require("../apm_main_template");
var _analyze_data_button = require("./analyze_data_button");
var _use_apm_feature_flag = require("../../../../hooks/use_apm_feature_flag");
var _apm_feature_flags = require("../../../../../common/apm_feature_flags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmServiceTemplate(props) {
  return /*#__PURE__*/_react.default.createElement(_apm_service_context.ApmServiceContextProvider, null, /*#__PURE__*/_react.default.createElement(TemplateWithContext, props));
}
function TemplateWithContext({
  title,
  children,
  selectedTab,
  searchBarOptions
}) {
  const {
    path: {
      serviceName
    },
    query,
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/*');
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const router = (0, _use_apm_router.useApmRouter)();
  const tabs = useTabs({
    selectedTab
  });
  const {
    agentName,
    serviceAgentStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isPendingServiceAgent = !agentName && (0, _use_fetcher.isPending)(serviceAgentStatus);
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title,
    href: router.link(`/services/{serviceName}/${selectedTab}`, {
      path: {
        serviceName
      },
      query
    })
  }), [query, router, selectedTab, serviceName, title]);
  if ((0, _agent_name.isMobileAgentName)(agentName)) {
    (0, _url_helpers.replace)(history, {
      pathname: location.pathname.replace('/services/', '/mobile-services/')
    });
  }
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageHeader: {
      tabs,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "l"
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "apmMainTemplateHeaderServiceName"
      }, serviceName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_service_icons.ServiceIcons, {
        serviceName: serviceName,
        start: start,
        end: end
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_analyze_data_button.AnalyzeDataButton, null)))
    }
  }, isPendingServiceAgent ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoObservability",
    size: "l"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, searchBarOptions), /*#__PURE__*/_react.default.createElement(_service_anomaly_timeseries_context.ServiceAnomalyTimeseriesContextProvider, null, children)));
}
function isMetricsTabHidden({
  agentName,
  serverlessType,
  isAwsLambdaEnabled
}) {
  if ((0, _agent_name.isAWSLambdaAgent)(serverlessType)) {
    return !isAwsLambdaEnabled;
  }
  return !agentName || (0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isAzureFunctionsAgent)(serverlessType);
}
function isInfraTabHidden({
  agentName,
  serverlessType,
  isInfraTabAvailable
}) {
  return !agentName || (0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isServerlessAgent)(serverlessType) || !isInfraTabAvailable;
}
function useTabs({
  selectedTab
}) {
  const {
    agentName,
    serverlessType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    core,
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    capabilities
  } = core.application;
  const {
    isAlertingAvailable,
    canReadAlerts
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(plugins, capabilities);
  const router = (0, _use_apm_router.useApmRouter)();
  const isInfraTabAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.InfrastructureTabAvailable);
  const isAwsLambdaEnabled = core.uiSettings.get(_common.enableAwsLambdaMetrics, true);
  const {
    path: {
      serviceName
    },
    query: queryFromUrl
  } = (0, _use_apm_params.useApmParams)(`/services/{serviceName}/${selectedTab}`);
  const {
    rangeFrom,
    rangeTo,
    environment
  } = queryFromUrl;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: serviceAlertsCount = {
      alertsCount: 0
    }
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/alerts_count', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment
        }
      }
    });
  }, [serviceName, start, end, environment]);
  const query = (0, _lodash.omit)(queryFromUrl, 'page', 'pageSize', 'sortField', 'sortDirection');
  const tabs = [{
    key: 'overview',
    href: router.link('/services/{serviceName}/overview', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.overviewTabLabel', {
      defaultMessage: 'Overview'
    })
  }, {
    key: 'transactions',
    href: router.link('/services/{serviceName}/transactions', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.transactionsTabLabel', {
      defaultMessage: 'Transactions'
    })
  }, {
    key: 'dependencies',
    href: router.link('/services/{serviceName}/dependencies', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.dependenciesTabLabel', {
      defaultMessage: 'Dependencies'
    }),
    hidden: !agentName || (0, _agent_name.isRumAgentName)(agentName)
  }, {
    key: 'errors',
    href: router.link('/services/{serviceName}/errors', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.errorsTabLabel', {
      defaultMessage: 'Errors'
    })
  }, {
    key: 'metrics',
    href: router.link('/services/{serviceName}/metrics', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.serviceDetails.metricsTabLabel', {
      defaultMessage: 'Metrics'
    }),
    append: (0, _agent_name.isServerlessAgent)(serverlessType) && /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker"
    }),
    hidden: isMetricsTabHidden({
      agentName,
      serverlessType,
      isAwsLambdaEnabled
    })
  }, {
    key: 'infrastructure',
    href: router.link('/services/{serviceName}/infrastructure', {
      path: {
        serviceName
      },
      query
    }),
    append: /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
      icon: "beta"
    }),
    label: _i18n.i18n.translate('xpack.apm.home.infraTabLabel', {
      defaultMessage: 'Infrastructure'
    }),
    hidden: isInfraTabHidden({
      agentName,
      serverlessType,
      isInfraTabAvailable
    })
  }, {
    key: 'service-map',
    href: router.link('/services/{serviceName}/service-map', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.serviceMapTabLabel', {
      defaultMessage: 'Service Map'
    })
  }, {
    key: 'logs',
    href: router.link('/services/{serviceName}/logs', {
      path: {
        serviceName
      },
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.home.serviceLogsTabLabel', {
      defaultMessage: 'Logs'
    }),
    append: (0, _agent_name.isServerlessAgent)(serverlessType) && /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker"
    }),
    hidden: !agentName || (0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isAzureFunctionsAgent)(serverlessType)
  }, {
    key: 'alerts',
    href: router.link('/services/{serviceName}/alerts', {
      path: {
        serviceName
      },
      query
    }),
    append: serviceAlertsCount.alertsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.apm.home.serviceAlertsTable.tooltip.activeAlertsExplanation', {
        defaultMessage: 'Active alerts'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger"
    }, serviceAlertsCount.alertsCount)) : null,
    label: _i18n.i18n.translate('xpack.apm.home.alertsTabLabel', {
      defaultMessage: 'Alerts'
    }),
    hidden: !(isAlertingAvailable && canReadAlerts)
  }];
  return tabs.filter(t => !t.hidden).map(({
    href,
    key,
    label,
    prepend,
    append
  }) => ({
    href,
    label,
    prepend,
    append,
    isSelected: key === selectedTab,
    'data-test-subj': `${key}Tab`
  }));
}