"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabsFlyout = LabsFlyout;
var _eui = require("@elastic/eui");
var _public = require("@kbn/advanced-settings-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_editable_settings = require("../../../../../hooks/use_apm_editable_settings");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LabsFlyout({
  onClose
}) {
  const {
    docLinks,
    notifications
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/settings/labs'), []);
  const labsItems = (data === null || data === void 0 ? void 0 : data.labsItems) || [];
  const {
    handleFieldChange,
    settingsEditableConfig,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _use_apm_editable_settings.useApmEditableSettings)(labsItems);
  async function handleSave() {
    try {
      const reloadPage = Object.keys(unsavedChanges).some(key => {
        return settingsEditableConfig[key].requiresPageReload;
      });
      await saveAll({
        trackMetricName: 'labs_save'
      });
      if (reloadPage) {
        window.location.reload();
      } else {
        onClose();
      }
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.apmSettings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  function handelCancel() {
    cleanUnsavedChanges();
    onClose();
  }
  const isLoading = (0, _use_fetcher.isPending)(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.labs', {
    defaultMessage: 'Labs'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.apm.labs.description', {
    defaultMessage: 'Try out the APM features that are under technical preview and in progress.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "labsFeedbackButton",
    href: "https://ela.st/feedback-apm-labs",
    target: "_blank",
    color: "warning",
    iconType: "editorComment"
  }, _i18n.i18n.translate('xpack.apm.labs.feedbackButtonLabel', {
    defaultMessage: 'Tell us what you think!'
  }))))), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, labsItems.map((settingKey, i) => {
    const editableConfig = settingsEditableConfig[settingKey];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.LazyField, {
      key: settingKey,
      setting: editableConfig,
      handleChange: handleFieldChange,
      enableSaving: true,
      docLinks: docLinks.links,
      toasts: notifications.toasts,
      unsavedChanges: unsavedChanges[settingKey]
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmLabsFlyoutCancelButton",
    onClick: handelCancel
  }, _i18n.i18n.translate('xpack.apm.labs.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmLabsFlyoutReloadToApplyChangesButton",
    fill: true,
    isLoading: isSaving,
    onClick: handleSave
  }, _i18n.i18n.translate('xpack.apm.labs.reload', {
    defaultMessage: 'Reload to apply changes'
  })))))));
}