"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDetailsTabs = TransactionDetailsTabs;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_transaction_trace_samples_fetcher = require("../../../hooks/use_transaction_trace_samples_fetcher");
var _maybe = require("../../../../common/utils/maybe");
var _url_helpers = require("../../shared/links/url_helpers");
var _failed_transactions_correlations_tab = require("./failed_transactions_correlations_tab");
var _latency_correlations_tab = require("./latency_correlations_tab");
var _trace_samples_tab = require("./trace_samples_tab");
var _use_sample_chart_selection = require("../../../hooks/use_sample_chart_selection");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_critical_path_feature_enabled_setting = require("../../../hooks/use_critical_path_feature_enabled_setting");
var _aggregated_critical_path_tab = require("./aggregated_critical_path_tab");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [_trace_samples_tab.traceSamplesTab, _latency_correlations_tab.latencyCorrelationsTab, _failed_transactions_correlations_tab.failedTransactionsCorrelationsTab];
function TransactionDetailsTabs() {
  var _availableTabs$find;
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const isCriticalPathFeatureEnabled = (0, _use_critical_path_feature_enabled_setting.useCriticalPathFeatureEnabledSetting)();
  const availableTabs = isCriticalPathFeatureEnabled ? tabs.concat(_aggregated_critical_path_tab.aggregatedCriticalPathTab) : tabs;
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const [currentTab, setCurrentTab] = (0, _react.useState)(_trace_samples_tab.traceSamplesTab.key);
  const {
    component: TabContent
  } = (_availableTabs$find = availableTabs.find(tab => tab.key === currentTab)) !== null && _availableTabs$find !== void 0 ? _availableTabs$find : _trace_samples_tab.traceSamplesTab;
  const {
    environment,
    kuery,
    transactionName
  } = query;
  const traceSamplesFetchResult = (0, _use_transaction_trace_samples_fetcher.useTransactionTraceSamplesFetcher)({
    transactionName,
    kuery,
    environment
  });
  const {
    sampleRangeFrom,
    sampleRangeTo,
    transactionId,
    traceId
  } = urlParams;
  const {
    clearChartSelection,
    selectSampleFromChartSelection
  } = (0, _use_sample_chart_selection.useSampleChartSelection)();

  // When filtering in either the latency correlations or failed transactions correlations tab,
  // scroll to the top of the page and switch to the 'Trace samples' tab to trigger a refresh.
  const traceSamplesTabKey = _trace_samples_tab.traceSamplesTab.key;
  const onFilter = (0, _react.useCallback)(() => {
    // Scroll to the top of the page
    window.scrollTo(0, 0);
    // Switch back to the 'trace samples' tab
    setCurrentTab(traceSamplesTabKey);
  }, [traceSamplesTabKey]);
  (0, _react.useEffect)(() => {
    var _traceSamplesFetchRes;
    const selectedSample = (_traceSamplesFetchRes = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes === void 0 ? void 0 : _traceSamplesFetchRes.traceSamples.find(sample => sample.transactionId === transactionId && sample.traceId === traceId);
    if (traceSamplesFetchResult.status === _use_fetcher.FETCH_STATUS.SUCCESS && !selectedSample) {
      var _traceSamplesFetchRes2;
      // selected sample was not found. select a new one:
      const preferredSample = (0, _maybe.maybe)((_traceSamplesFetchRes2 = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes2 === void 0 ? void 0 : _traceSamplesFetchRes2.traceSamples[0]);
      history.replace({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _lodash.omit)((0, _url_helpers.toQuery)(history.location.search), ['traceId', 'transactionId']),
          ...preferredSample
        })
      });
    }
  }, [history, transactionId, traceId, traceSamplesFetchResult]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, availableTabs.map(({
    dataTestSubj,
    key,
    label
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": dataTestSubj,
    key: key,
    isSelected: key === currentTab,
    onClick: () => {
      setCurrentTab(key);
    }
  }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(TabContent, {
    clearChartSelection,
    onFilter,
    sampleRangeFrom,
    sampleRangeTo,
    selectSampleFromChartSelection,
    traceSamplesFetchResult
  })));
}