"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceExplorerAggregatedCriticalPath = TraceExplorerAggregatedCriticalPath;
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_trace_explorer_samples = require("../../../hooks/use_trace_explorer_samples");
var _critical_path_flamegraph = require("../../shared/critical_path_flamegraph");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceExplorerAggregatedCriticalPath() {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/traces/explorer/critical_path');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: {
      traceSamples
    },
    status: samplesFetchStatus
  } = (0, _use_trace_explorer_samples.useTraceExplorerSamples)();
  const traceIds = (0, _react.useMemo)(() => {
    return traceSamples.map(sample => sample.traceId);
  }, [traceSamples]);
  return /*#__PURE__*/_react.default.createElement(_critical_path_flamegraph.CriticalPathFlamegraph, {
    start: start,
    end: end,
    traceIds: traceIds,
    traceIdsFetchStatus: samplesFetchStatus
  });
}