"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmSwitchModal = ConfirmSwitchModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _elastic_docs_link = require("../../../shared/links/elastic_docs_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfirmSwitchModal({
  onConfirm,
  onCancel,
  unsupportedConfigs
}) {
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const [isConfirmChecked, setIsConfirmChecked] = (0, _react.useState)(false);
  const hasUnsupportedConfigs = !!unsupportedConfigs.length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.title', {
      defaultMessage: 'Please confirm your choice'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.cancelText', {
      defaultMessage: 'Cancel'
    }),
    onCancel: onCancel,
    confirmButtonText: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.switchButtonText', {
      defaultMessage: 'Switch to Elastic Agent'
    }),
    defaultFocusedButton: "confirm",
    onConfirm: () => {
      trackApmEvent({
        metric: 'confirm_data_stream_switch'
      });
      onConfirm();
    },
    confirmButtonDisabled: !isConfirmChecked
  }, !hasUnsupportedConfigs && /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.settings.schema.confirm.unsupportedConfigs.descriptionText', {
    defaultMessage: `Compatible custom apm-server.yml user settings will be moved to Fleet Server settings for you. We'll let you know which settings are incompatible before removing them.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.irreversibleWarning.title', {
      defaultMessage: `Switching to Elastic Agent is an irreversible action`
    }),
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.settings.schema.confirm.irreversibleWarning.message', {
    defaultMessage: `It might temporarily affect your APM data collection while the migration is in progress. The process of migrating should only take a few minutes.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), hasUnsupportedConfigs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.unsupportedConfigs.title', {
      defaultMessage: `The following apm-server.yml user settings are incompatible and will be removed`
    }),
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml"
  }, unsupportedConfigs.map(({
    key,
    value
  }) => `${key}: ${JSON.stringify(value)}`).join('\n')), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_elastic_docs_link.ElasticDocsLink, {
    section: "/cloud",
    path: "/ec-manage-apm-settings.html",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.apm.settings.schema.confirm.apmServerSettingsCloudLinkText', {
    defaultMessage: 'Go to APM Server settings in Cloud'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: (0, _eui.htmlIdGenerator)()(),
    label: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.checkboxLabel', {
      defaultMessage: `I confirm that I wish to switch to Elastic Agent`
    }),
    checked: isConfirmChecked,
    onChange: e => {
      setIsConfirmChecked(e.target.checked);
    }
  })));
}