"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormRowSelect = FormRowSelect;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FormRowSelect({
  title,
  description,
  fieldLabel,
  isLoading,
  options,
  isDisabled,
  onChange,
  value,
  dataTestSubj
}) {
  const selectedOptions = (0, _react.useMemo)(() => {
    const optionFound = options === null || options === void 0 ? void 0 : options.find(option => option.value === value);
    return optionFound ? [optionFound] : undefined;
  }, [options, value]);
  const handleOnChange = nextSelectedOptions => {
    const [selectedOption] = nextSelectedOptions;
    onChange(selectedOption.value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, title),
    description: description
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: fieldLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    isLoading: isLoading,
    singleSelection: {
      asPlainText: true
    },
    options: options,
    isDisabled: isDisabled,
    selectedOptions: selectedOptions,
    onChange: handleOnChange,
    placeholder: _i18n.i18n.translate('xpack.apm.agentConfig.servicePage.environment.placeholder', {
      defaultMessage: 'Select Option'
    }),
    "data-test-subj": dataTestSubj
  })));
}