"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.iconForNode = iconForNode;
var _apm = require("../../../../common/es_fields/apm");
var _get_agent_icon = require("../../shared/agent_icon/get_agent_icon");
var _get_span_icon = require("../../shared/span_icon/get_span_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function iconForNode(node) {
  const agentName = node.data(_apm.AGENT_NAME);
  const subtype = node.data(_apm.SPAN_SUBTYPE);
  const type = node.data(_apm.SPAN_TYPE);
  return agentName ? (0, _get_agent_icon.getAgentIcon)(agentName, false) : (0, _get_span_icon.getSpanIcon)(type, subtype);
}