"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTelemetryInstructions = OpenTelemetryInstructions;
exports.createOpenTelemetryAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _api_key_callout = require("./api_key_callout");
var _agent_status_instructions = require("../agent_status_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOpenTelemetryAgentInstructions = commonOptions => {
  const {
    baseUrl,
    apmServerUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.otel.download.title', {
      defaultMessage: 'Download the OpenTelemetry APM Agent or SDK'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.otel.download.textPre', {
      defaultMessage: 'See the [OpenTelemetry Instrumentation guides]({openTelemetryInstrumentationLink}) to download the OpenTelemetry Agent or SDK for your language.',
      values: {
        openTelemetryInstrumentationLink: 'https://opentelemetry.io/docs/instrumentation'
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.otel.configureAgent.title', {
      defaultMessage: 'Configure OpenTelemetry in your application'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.otel.configureAgent.textPre', {
      defaultMessage: 'Specify the following OpenTelemetry settings as part of the startup of your application. Note that OpenTelemetry SDKs require some bootstrap code in addition to these configuration settings. For more details, see the [Elastic OpenTelemetry documentation]({openTelemetryDocumentationLink}) and the [OpenTelemetry community instrumentation guides]({openTelemetryInstrumentationLink}).',
      values: {
        openTelemetryDocumentationLink: `${baseUrl}guide/en/apm/guide/current/open-telemetry.html`,
        openTelemetryInstrumentationLink: 'https://opentelemetry.io/docs/instrumentation'
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
      isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
      isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
      errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(OpenTelemetryInstructions, {
      apmServerUrl: apmServerUrl,
      apiKeyDetails: apiKeyDetails
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.otel.configureAgent.textPost', {
      defaultMessage: 'See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/guide/current/open-telemetry.html`
      }
    })))
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createOpenTelemetryAgentInstructions = createOpenTelemetryAgentInstructions;
function ConfigurationValueColumn({
  setting,
  value,
  createApiKey,
  createApiKeyLoading,
  apiKey
}) {
  const shouldRenderCreateApiKeyButton = setting === 'OTEL_EXPORTER_OTLP_HEADERS' && apiKey === null;
  if (shouldRenderCreateApiKeyButton) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "createApiKeyAndId",
      fill: true,
      onClick: createApiKey,
      isLoading: createApiKeyLoading
    }, _i18n.i18n.translate('xpack.apm.onboarding.apiKey.create', {
      defaultMessage: 'Create API Key'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "accent"
  }, value);
}
function OpenTelemetryInstructions({
  apmServerUrl,
  secretToken,
  apiKeyDetails
}) {
  let authHeaderValue;
  if (secretToken) {
    authHeaderValue = `Authorization=Bearer ${secretToken}`;
  } else {
    authHeaderValue = `Authorization=ApiKey ${apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey}`;
  }
  const items = [{
    setting: 'OTEL_EXPORTER_OTLP_ENDPOINT',
    value: apmServerUrl ? apmServerUrl : '<apm-server-url>'
  }, {
    setting: 'OTEL_EXPORTER_OTLP_HEADERS',
    value: authHeaderValue,
    apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey
  }, {
    setting: 'OTEL_METRICS_EXPORTER',
    value: 'otlp',
    notes: 'Enable metrics when supported by your OpenTelemetry client.'
  }, {
    setting: 'OTEL_LOGS_EXPORTER',
    value: 'otlp',
    notes: 'Enable logs when supported by your OpenTelemetry client'
  }, {
    setting: 'OTEL_RESOURCE_ATTRIBUTES',
    value: 'service.name=<app-name>,service.version=<app-version>,deployment.environment=production'
  }];
  const columns = [{
    field: 'setting',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_otel.column.configSettings', {
      defaultMessage: 'Configuration setting (1)'
    })
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_otel.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value,
      setting,
      apiKey
    }) => /*#__PURE__*/_react.default.createElement(ConfigurationValueColumn, {
      setting: setting,
      value: value,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey
    })
  }, {
    field: 'notes',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_otel.column.notes', {
      defaultMessage: 'Notes'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    "data-test-subj": "otel-instructions-table"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.onboarding.config_otel.description1",
    defaultMessage: "(1) OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",
    values: {
      otelExporterOtlpEndpoint: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",
        target: "_blank",
        href: "https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"
      }, "OTEL_EXPORTER_OTLP_ENDPOINT"),
      otelExporterOtlpHeaders: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",
        target: "_blank",
        href: "https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md"
      }, "OTEL_EXPORTER_OTLP_HEADERS"),
      otelResourceAttributes: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelResourceAttributesLink",
        target: "_blank",
        href: "https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/resource/sdk.md"
      }, "OTEL_RESOURCE_ATTRIBUTES")
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.onboarding.config_otel.description2",
    defaultMessage: "The 'OTEL_METRICS_EXPORTER` and 'OTEL_LOGS_EXPORTER' environment variables may not be supported by some SDKs."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.onboarding.config_otel.description3",
    defaultMessage: "The exhaustive list of environment variables, command line parameters, and configuration code snippets (according to the OpenTelemetry specification) is available in the {otelInstrumentationGuide}. Some unstable OpenTelemetry clients may not support all features and may require alternate configuration mechanisms.",
    values: {
      otelInstrumentationGuide: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOpenTelemetryInstrumentationGuideLink",
        target: "_blank",
        href: "https://opentelemetry.io/docs/instrumentation"
      }, _i18n.i18n.translate('xpack.apm.onboarding.config_otel.instrumentationGuide', {
        defaultMessage: 'OpenTelemetry Instrumentation guide'
      }))
    }
  })));
}