"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.phpVariables = exports.phpLineNumbers = exports.phpHighlightLang = exports.php = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const phpVariables = secretToken => ({
  ...(secretToken && {
    secretToken: 'elastic_apm.secret_token'
  }),
  ...(!secretToken && {
    apiKey: 'elastic_apm.api_key'
  }),
  apmServerUrl: 'elastic_apm.server_url'
});
exports.phpVariables = phpVariables;
const phpHighlightLang = 'php';
exports.phpHighlightLang = phpHighlightLang;
const phpLineNumbers = () => ({
  start: 1,
  highlight: '2, 5, 8, 11'
});
exports.phpLineNumbers = phpLineNumbers;
const php = `# {{serviceNameHint}}
elastic_apm.service_name="<your-service-name>"

{{^secretToken}}
# {{apiKeyHint}}
elastic_apm.api_key="{{{apiKey}}}"
{{/secretToken}}
{{#secretToken}}
# {{secretTokenHint}}
elastic_apm.secret_token="{{{secretToken}}}"
{{/secretToken}}

# {{serverUrlHint}}
elastic_apm.server_url="{{{apmServerUrl}}}"

# {{{serviceEnvironmentHint}}}
elastic_apm.environment="<your-environment>"`;
exports.php = php;