"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorSampleCoPilotPrompt = ErrorSampleCoPilotPrompt;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _error_tabs = require("./error_tabs");
var _error_sample_detail = require("./error_sample_detail");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorSampleCoPilotPrompt({
  error,
  transaction
}) {
  var _error$error$log, _error$error$exceptio;
  const coPilot = (0, _public.useCoPilot)();
  const [logStacktrace, setLogStacktrace] = (0, _react.useState)('');
  const [exceptionStacktrace, setExceptionStacktrace] = (0, _react.useState)('');
  const promptParams = (0, _react.useMemo)(() => {
    var _error$service$langua, _error$service$langua2, _error$service$runtim, _error$service$runtim2, _error$service$runtim3, _error$service$runtim4, _transaction$transact;
    return {
      serviceName: error.service.name,
      languageName: (_error$service$langua = (_error$service$langua2 = error.service.language) === null || _error$service$langua2 === void 0 ? void 0 : _error$service$langua2.name) !== null && _error$service$langua !== void 0 ? _error$service$langua : '',
      runtimeName: (_error$service$runtim = (_error$service$runtim2 = error.service.runtime) === null || _error$service$runtim2 === void 0 ? void 0 : _error$service$runtim2.name) !== null && _error$service$runtim !== void 0 ? _error$service$runtim : '',
      runtimeVersion: (_error$service$runtim3 = (_error$service$runtim4 = error.service.runtime) === null || _error$service$runtim4 === void 0 ? void 0 : _error$service$runtim4.version) !== null && _error$service$runtim3 !== void 0 ? _error$service$runtim3 : '',
      transactionName: (_transaction$transact = transaction === null || transaction === void 0 ? void 0 : transaction.transaction.name) !== null && _transaction$transact !== void 0 ? _transaction$transact : '',
      logStacktrace,
      exceptionStacktrace
    };
  }, [error, transaction, logStacktrace, exceptionStacktrace]);
  return coPilot !== null && coPilot !== void 0 && coPilot.isEnabled() && promptParams ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.CoPilotPrompt, {
    coPilot: coPilot,
    title: _i18n.i18n.translate('xpack.apm.errorGroupCoPilotPrompt.explainErrorTitle', {
      defaultMessage: "What's this error?"
    }),
    promptId: _common.CoPilotPromptId.ApmExplainError,
    params: promptParams,
    feedbackEnabled: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: next => {
      var _next$innerText;
      setLogStacktrace((_next$innerText = next === null || next === void 0 ? void 0 : next.innerText) !== null && _next$innerText !== void 0 ? _next$innerText : '');
    },
    style: {
      display: 'none'
    }
  }, ((_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.message) && /*#__PURE__*/_react.default.createElement(_error_sample_detail.ErrorSampleDetailTabContent, {
    error: error,
    currentTab: _error_tabs.logStacktraceTab
  })), /*#__PURE__*/_react.default.createElement("div", {
    ref: next => {
      var _next$innerText2;
      setExceptionStacktrace((_next$innerText2 = next === null || next === void 0 ? void 0 : next.innerText) !== null && _next$innerText2 !== void 0 ? _next$innerText2 : '');
    },
    style: {
      display: 'none'
    }
  }, ((_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : _error$error$exceptio.length) && /*#__PURE__*/_react.default.createElement(_error_sample_detail.ErrorSampleDetailTabContent, {
    error: error,
    currentTab: _error_tabs.exceptionStacktraceTab
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}