"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyDetailOperationsList = DependencyDetailOperationsList;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_search_service_destination_metrics = require("../../../../context/time_range_metadata/use_search_service_destination_metrics");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _get_span_metric_columns = require("../../../shared/dependencies_table/get_span_metric_columns");
var _empty_message = require("../../../shared/empty_message");
var _managed_table = require("../../../shared/managed_table");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _truncate_with_tooltip = require("../../../shared/truncate_with_tooltip");
var _dependency_operation_detail_link = require("../../dependency_operation_detail_view/dependency_operation_detail_link");
var _transaction_tabs = require("../../transaction_details/waterfall_with_summary/transaction_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OperationLink({
  spanName
}) {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/dependencies/operations');
  return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
    "data-test-subj": "apmOperationsListAppLink",
    text: spanName,
    content: /*#__PURE__*/_react.default.createElement(_dependency_operation_detail_link.DependencyOperationDetailLink, (0, _extends2.default)({}, query, {
      spanName: spanName,
      detailTab: _transaction_tabs.TransactionTab.timeline,
      showCriticalPath: false
    }))
  });
}
function DependencyDetailOperationsList() {
  var _comparisonStatsFetch, _primaryStatsFetch$da, _primaryStatsFetch$da2;
  const {
    query: {
      rangeFrom,
      rangeTo,
      dependencyName,
      environment,
      kuery,
      comparisonEnabled: urlComparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/operations');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const breakpoints = (0, _use_breakpoints.useBreakpoints)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled
  });
  const {
    searchServiceDestinationMetrics
  } = (0, _use_search_service_destination_metrics.useSearchServiceDestinationMetrics)({
    start,
    end,
    kuery
  });
  const primaryStatsFetch = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/dependencies/operations', {
      params: {
        query: {
          dependencyName,
          start,
          end,
          environment,
          kuery,
          searchServiceDestinationMetrics
        }
      }
    });
  }, [dependencyName, start, end, environment, kuery, searchServiceDestinationMetrics]);
  const comparisonStatsFetch = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!comparisonEnabled) {
      return Promise.resolve({
        operations: []
      });
    }
    return callApmApi('GET /internal/apm/dependencies/operations', {
      params: {
        query: {
          dependencyName,
          start,
          end,
          offset,
          environment,
          kuery,
          searchServiceDestinationMetrics
        }
      }
    });
  }, [dependencyName, start, end, offset, environment, kuery, comparisonEnabled, searchServiceDestinationMetrics]);
  const columns = [{
    name: _i18n.i18n.translate('xpack.apm.dependencyDetailOperationsList.spanNameColumnLabel', {
      defaultMessage: 'Span name'
    }),
    field: 'spanName',
    sortable: true,
    render: (_, {
      spanName
    }) => /*#__PURE__*/_react.default.createElement(OperationLink, {
      spanName: spanName
    })
  }, ...(0, _get_span_metric_columns.getSpanMetricColumns)({
    breakpoints,
    comparisonFetchStatus: comparisonStatsFetch.status
  })];
  const comparisonOperationsBySpanName = (0, _lodash.keyBy)((_comparisonStatsFetch = comparisonStatsFetch.data) === null || _comparisonStatsFetch === void 0 ? void 0 : _comparisonStatsFetch.operations, 'spanName');
  const noItemsMessage = /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
    heading: _i18n.i18n.translate('xpack.apm.dependencyDetailOperationsList.notFoundLabel', {
      defaultMessage: 'No operations found'
    })
  });
  const items = (_primaryStatsFetch$da = (_primaryStatsFetch$da2 = primaryStatsFetch.data) === null || _primaryStatsFetch$da2 === void 0 ? void 0 : _primaryStatsFetch$da2.operations.map(operation => {
    const comparisonOperation = comparisonOperationsBySpanName[operation.spanName];
    return {
      spanName: operation.spanName,
      latency: operation.latency,
      throughput: operation.throughput,
      failureRate: operation.failureRate,
      impact: operation.impact,
      currentStats: {
        latency: operation.timeseries.latency,
        throughput: operation.timeseries.throughput,
        failureRate: operation.timeseries.failureRate
      },
      previousStats: comparisonOperation ? {
        latency: comparisonOperation.timeseries.latency,
        throughput: comparisonOperation.timeseries.throughput,
        failureRate: comparisonOperation.timeseries.failureRate,
        impact: comparisonOperation.impact
      } : undefined
    };
  })) !== null && _primaryStatsFetch$da !== void 0 ? _primaryStatsFetch$da : [];
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    columns: columns,
    items: items,
    noItemsMessage: noItemsMessage,
    initialSortField: "impact",
    initialSortDirection: "desc",
    isLoading: primaryStatsFetch.status === _use_fetcher.FETCH_STATUS.LOADING,
    initialPageSize: 25
  });
}