"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPreview = ChartPreview;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _use_theme = require("../../../../hooks/use_theme");
var _timezone = require("../../../shared/charts/helper/timezone");
var _chart_preview_helper = require("./chart_preview_helper");
var _helper = require("../../utils/helper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChartPreview({
  yTickFormat,
  threshold,
  uiSettings,
  series,
  timeSize = 5,
  timeUnit = 'm',
  totalGroups
}) {
  const theme = (0, _use_theme.useTheme)();
  const thresholdOpacity = 0.3;
  const DEFAULT_DATE_FORMAT = 'Y-MM-DD HH:mm:ss';
  const style = {
    fill: theme.eui.euiColorVis2,
    line: {
      strokeWidth: 2,
      stroke: theme.eui.euiColorVis2,
      opacity: 1
    },
    opacity: thresholdOpacity
  };
  const barSeries = (0, _react.useMemo)(() => {
    return series.flatMap(serie => serie.data.map(point => ({
      ...point,
      groupBy: serie.name
    })));
  }, [series]);
  const timeZone = (0, _timezone.getTimeZone)(uiSettings);
  const legendSize = series.length > 1 ? Math.ceil(series.length / 2) * 30 : series.length * 35;
  const chartSize = 150;
  const {
    yMin,
    yMax,
    xMin,
    xMax
  } = (0, _chart_preview_helper.getDomain)(series);
  const chartDomain = {
    max: Math.max(yMax, threshold) * 1.1,
    // Add 10% headroom.
    min: Math.min(yMin, threshold) * 0.9 // Add 10% headroom.
  };

  const dateFormatter = (0, _react.useMemo)(() => (0, _charts.niceTimeFormatter)([xMin, xMax]), [xMin, xMax]);
  const lookback = timeSize * _helper.ALERT_PREVIEW_BUCKET_SIZE;
  const timeLabel = _chart_preview_helper.TIME_LABELS[timeUnit];
  const rectDataValues = [{
    coordinates: {
      x0: xMin,
      x1: xMax,
      y0: threshold,
      y1: chartDomain.max
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: chartSize + legendSize
    },
    "data-test-subj": "ChartPreview"
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: "none",
    headerFormatter: ({
      value
    }) => {
      const dateFormat = uiSettings && uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT) || DEFAULT_DATE_FORMAT;
      return (0, _moment.default)(value).format(dateFormat);
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: 'bottom',
    legendSize: legendSize
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    dataValues: [{
      dataValue: threshold
    }],
    domainType: _charts.AnnotationDomainType.YDomain,
    id: "chart_preview_line_annotation",
    markerPosition: "left",
    style: style
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: rectDataValues,
    hideTooltips: true,
    id: "chart_preview_rect_annotation",
    style: style
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_x_axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_y_axis",
    position: _charts.Position.Left,
    tickFormat: yTickFormat,
    ticks: 5,
    domain: chartDomain
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "apm-chart-preview",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    splitSeriesAccessors: ['groupBy'],
    data: barSeries,
    barSeriesStyle: {
      rectBorder: {
        strokeWidth: 1,
        visible: true
      },
      rect: {
        opacity: 1
      }
    },
    timeZone: timeZone
  })), series.length > 0 && /*#__PURE__*/_react.default.createElement(_chart_preview_helper.TimeLabelForData, {
    lookback: lookback,
    timeLabel: timeLabel,
    displayedGroups: series.length,
    totalGroups: totalGroups
  }));
}