"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMRuleGroupBy = APMRuleGroupBy;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function APMRuleGroupBy({
  options,
  fields,
  preSelectedOptions,
  onChange,
  errorOptions
}) {
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupByOption = selectedOptions.map(option => option.label);
    onChange([...new Set(preSelectedOptions.concat(groupByOption))]);
  }, [onChange, preSelectedOptions]);
  const getPreSelectedOptions = () => {
    return preSelectedOptions.map(field => ({
      label: field,
      color: 'lightgray',
      disabled: true
    }));
  };
  const getUserSelectedOptions = groupBy => {
    return (groupBy !== null && groupBy !== void 0 ? groupBy : []).filter(group => !preSelectedOptions.includes(group)).map(field => ({
      label: field,
      color: errorOptions !== null && errorOptions !== void 0 && errorOptions.includes(field) ? 'danger' : undefined
    }));
  };
  const selectedOptions = [...getPreSelectedOptions(), ...getUserSelectedOptions(options.groupBy)];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "apmRule-groupBy",
    placeholder: _i18n.i18n.translate('xpack.apm.ruleFlyout.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.apm.ruleFlyout.groupByAriaLabel', {
      defaultMessage: 'Group by'
    }),
    fullWidth: true,
    singleSelection: false,
    selectedOptions: selectedOptions,
    options: fields.map(field => ({
      label: field
    })),
    onChange: handleChange,
    isClearable: false
  });
}