"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKueryWithMobileFilters = getKueryWithMobileFilters;
var _apm = require("../es_fields/apm");
var _field_value_pair_to_kql = require("./field_value_pair_to_kql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKueryWithMobileFilters({
  device,
  osVersion,
  appVersion,
  netConnectionType,
  kuery
}) {
  const kueryWithFilters = [kuery, ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.DEVICE_MODEL_IDENTIFIER, device), ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.HOST_OS_VERSION, osVersion), ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.SERVICE_VERSION, appVersion), ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.NETWORK_CONNECTION_TYPE, netConnectionType)].filter(Boolean).join(' and ');
  return kueryWithFilters;
}