"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionErrorRateParamsSchema = exports.transactionDurationParamsSchema = exports.errorCountParamsSchema = exports.anomalyParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
var _apm_rule_types = require("./apm_rule_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorCountParamsSchema = _configSchema.schema.object({
  windowSize: _configSchema.schema.number(),
  windowUnit: _configSchema.schema.string(),
  threshold: _configSchema.schema.number(),
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  environment: _configSchema.schema.string(),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  errorGroupingKey: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.errorCountParamsSchema = errorCountParamsSchema;
const transactionDurationParamsSchema = _configSchema.schema.object({
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionName: _configSchema.schema.maybe(_configSchema.schema.string()),
  windowSize: _configSchema.schema.number(),
  windowUnit: _configSchema.schema.string(),
  threshold: _configSchema.schema.number(),
  aggregationType: _configSchema.schema.oneOf([_configSchema.schema.literal(_apm_rule_types.AggregationType.Avg), _configSchema.schema.literal(_apm_rule_types.AggregationType.P95), _configSchema.schema.literal(_apm_rule_types.AggregationType.P99)]),
  environment: _configSchema.schema.string(),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
exports.transactionDurationParamsSchema = transactionDurationParamsSchema;
const anomalyParamsSchema = _configSchema.schema.object({
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string()),
  windowSize: _configSchema.schema.number(),
  windowUnit: _configSchema.schema.string(),
  environment: _configSchema.schema.string(),
  anomalySeverityType: _configSchema.schema.oneOf([_configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.MINOR), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.WARNING)])
});
exports.anomalyParamsSchema = anomalyParamsSchema;
const transactionErrorRateParamsSchema = _configSchema.schema.object({
  windowSize: _configSchema.schema.number(),
  windowUnit: _configSchema.schema.string(),
  threshold: _configSchema.schema.number(),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionName: _configSchema.schema.maybe(_configSchema.schema.string()),
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  environment: _configSchema.schema.string(),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
exports.transactionErrorRateParamsSchema = transactionErrorRateParamsSchema;