"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTelemetryCounterHelper = createTelemetryCounterHelper;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Creates a telemetry counter helper to make it easier to generate them
 * @param telemetryCounter$ The observable that will be used to emit the telemetry counters
 * @param source The name of the shipper that is sending the events.
 */
function createTelemetryCounterHelper(telemetryCounter$, source) {
  /**
   * Triggers a telemetry counter for each event type.
   * @param events The events to trigger the telemetry counter for.
   * @param type The type of telemetry counter to trigger.
   * @param code The success or error code for additional detail about the result.
   * @param error The error that occurred, if any.
   */
  return (events, {
    type,
    code,
    error
  } = {}) => {
    const eventTypeCounts = countEventTypes(events);
    Object.entries(eventTypeCounts).forEach(([eventType, count]) => {
      var _ref;
      telemetryCounter$.next({
        source,
        type: type !== null && type !== void 0 ? type : error ? 'failed' : 'succeeded',
        code: (_ref = code !== null && code !== void 0 ? code : error === null || error === void 0 ? void 0 : error.message) !== null && _ref !== void 0 ? _ref : 'OK',
        count,
        event_type: eventType
      });
    });
  };
}
function countEventTypes(events) {
  return events.reduce((acc, event) => {
    if (acc[event.event_type]) {
      acc[event.event_type] += 1;
    } else {
      acc[event.event_type] = 1;
    }
    return acc;
  }, {});
}