"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.IsoDateString = exports.EcsSchema = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
exports.IsoDateString = IsoDateString;
const schemaDate = IsoDateString;
exports.schemaDate = schemaDate;
const schemaDateArray = rt.array(IsoDateString);
exports.schemaDateArray = schemaDateArray;
const schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
exports.schemaDateRange = schemaDateRange;
const schemaDateRangeArray = rt.array(schemaDateRange);
exports.schemaDateRangeArray = schemaDateRangeArray;
const schemaUnknown = rt.unknown;
exports.schemaUnknown = schemaUnknown;
const schemaUnknownArray = rt.array(rt.unknown);
exports.schemaUnknownArray = schemaUnknownArray;
const schemaString = rt.string;
exports.schemaString = schemaString;
const schemaStringArray = rt.array(schemaString);
exports.schemaStringArray = schemaStringArray;
const schemaNumber = rt.number;
exports.schemaNumber = schemaNumber;
const schemaNumberArray = rt.array(schemaNumber);
exports.schemaNumberArray = schemaNumberArray;
const schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
exports.schemaStringOrNumber = schemaStringOrNumber;
const schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
exports.schemaStringOrNumberArray = schemaStringOrNumberArray;
const schemaBoolean = rt.boolean;
exports.schemaBoolean = schemaBoolean;
const schemaBooleanArray = rt.array(schemaBoolean);
exports.schemaBooleanArray = schemaBooleanArray;
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
exports.schemaGeoPoint = schemaGeoPoint;
const schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
exports.schemaGeoPointArray = schemaGeoPointArray;
const EcsRequired = rt.type({
  '@timestamp': schemaDate,
  ecs: rt.type({
    version: schemaString
  })
});
const EcsOptional = rt.partial({
  agent: rt.partial({
    build: rt.partial({
      original: schemaString
    }),
    ephemeral_id: schemaString,
    id: schemaString,
    name: schemaString,
    type: schemaString,
    version: schemaString
  }),
  client: rt.partial({
    address: schemaString,
    as: rt.partial({
      number: schemaStringOrNumber,
      organization: rt.partial({
        name: schemaString
      })
    }),
    bytes: schemaStringOrNumber,
    domain: schemaString,
    geo: rt.partial({
      city_name: schemaString,
      continent_code: schemaString,
      continent_name: schemaString,
      country_iso_code: schemaString,
      country_name: schemaString,
      location: schemaGeoPoint,
      name: schemaString,
      postal_code: schemaString,
      region_iso_code: schemaString,
      region_name: schemaString,
      timezone: schemaString
    }),
    ip: schemaString,
    mac: schemaString,
    nat: rt.partial({
      ip: schemaString,
      port: schemaStringOrNumber
    }),
    packets: schemaStringOrNumber,
    port: schemaStringOrNumber,
    registered_domain: schemaString,
    subdomain: schemaString,
    top_level_domain: schemaString,
    user: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    })
  }),
  cloud: rt.partial({
    account: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    availability_zone: schemaString,
    instance: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    machine: rt.partial({
      type: schemaString
    }),
    origin: rt.partial({
      account: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      availability_zone: schemaString,
      instance: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      machine: rt.partial({
        type: schemaString
      }),
      project: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      provider: schemaString,
      region: schemaString,
      service: rt.partial({
        name: schemaString
      })
    }),
    project: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    provider: schemaString,
    region: schemaString,
    service: rt.partial({
      name: schemaString
    }),
    target: rt.partial({
      account: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      availability_zone: schemaString,
      instance: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      machine: rt.partial({
        type: schemaString
      }),
      project: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      provider: schemaString,
      region: schemaString,
      service: rt.partial({
        name: schemaString
      })
    })
  }),
  container: rt.partial({
    cpu: rt.partial({
      usage: schemaStringOrNumber
    }),
    disk: rt.partial({
      read: rt.partial({
        bytes: schemaStringOrNumber
      }),
      write: rt.partial({
        bytes: schemaStringOrNumber
      })
    }),
    id: schemaString,
    image: rt.partial({
      hash: rt.partial({
        all: schemaStringArray
      }),
      name: schemaString,
      tag: schemaStringArray
    }),
    memory: rt.partial({
      usage: schemaStringOrNumber
    }),
    name: schemaString,
    network: rt.partial({
      egress: rt.partial({
        bytes: schemaStringOrNumber
      }),
      ingress: rt.partial({
        bytes: schemaStringOrNumber
      })
    }),
    runtime: schemaString
  }),
  destination: rt.partial({
    address: schemaString,
    as: rt.partial({
      number: schemaStringOrNumber,
      organization: rt.partial({
        name: schemaString
      })
    }),
    bytes: schemaStringOrNumber,
    domain: schemaString,
    geo: rt.partial({
      city_name: schemaString,
      continent_code: schemaString,
      continent_name: schemaString,
      country_iso_code: schemaString,
      country_name: schemaString,
      location: schemaGeoPoint,
      name: schemaString,
      postal_code: schemaString,
      region_iso_code: schemaString,
      region_name: schemaString,
      timezone: schemaString
    }),
    ip: schemaString,
    mac: schemaString,
    nat: rt.partial({
      ip: schemaString,
      port: schemaStringOrNumber
    }),
    packets: schemaStringOrNumber,
    port: schemaStringOrNumber,
    registered_domain: schemaString,
    subdomain: schemaString,
    top_level_domain: schemaString,
    user: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    })
  }),
  device: rt.partial({
    id: schemaString,
    manufacturer: schemaString,
    model: rt.partial({
      identifier: schemaString,
      name: schemaString
    })
  }),
  dll: rt.partial({
    code_signature: rt.partial({
      digest_algorithm: schemaString,
      exists: schemaBoolean,
      signing_id: schemaString,
      status: schemaString,
      subject_name: schemaString,
      team_id: schemaString,
      timestamp: schemaDate,
      trusted: schemaBoolean,
      valid: schemaBoolean
    }),
    hash: rt.partial({
      md5: schemaString,
      sha1: schemaString,
      sha256: schemaString,
      sha384: schemaString,
      sha512: schemaString,
      ssdeep: schemaString,
      tlsh: schemaString
    }),
    name: schemaString,
    path: schemaString,
    pe: rt.partial({
      architecture: schemaString,
      company: schemaString,
      description: schemaString,
      file_version: schemaString,
      imphash: schemaString,
      original_file_name: schemaString,
      pehash: schemaString,
      product: schemaString
    })
  }),
  dns: rt.partial({
    answers: rt.array(rt.partial({
      class: schemaString,
      data: schemaString,
      name: schemaString,
      ttl: schemaStringOrNumber,
      type: schemaString
    })),
    header_flags: schemaStringArray,
    id: schemaString,
    op_code: schemaString,
    question: rt.partial({
      class: schemaString,
      name: schemaString,
      registered_domain: schemaString,
      subdomain: schemaString,
      top_level_domain: schemaString,
      type: schemaString
    }),
    resolved_ip: schemaStringArray,
    response_code: schemaString,
    type: schemaString
  }),
  email: rt.partial({
    attachments: rt.array(rt.partial({
      file: rt.partial({
        extension: schemaString,
        hash: rt.partial({
          md5: schemaString,
          sha1: schemaString,
          sha256: schemaString,
          sha384: schemaString,
          sha512: schemaString,
          ssdeep: schemaString,
          tlsh: schemaString
        }),
        mime_type: schemaString,
        name: schemaString,
        size: schemaStringOrNumber
      })
    })),
    bcc: rt.partial({
      address: schemaStringArray
    }),
    cc: rt.partial({
      address: schemaStringArray
    }),
    content_type: schemaString,
    delivery_timestamp: schemaDate,
    direction: schemaString,
    from: rt.partial({
      address: schemaStringArray
    }),
    local_id: schemaString,
    message_id: schemaString,
    origination_timestamp: schemaDate,
    reply_to: rt.partial({
      address: schemaStringArray
    }),
    sender: rt.partial({
      address: schemaString
    }),
    subject: schemaString,
    to: rt.partial({
      address: schemaStringArray
    }),
    x_mailer: schemaString
  }),
  error: rt.partial({
    code: schemaString,
    id: schemaString,
    message: schemaString,
    stack_trace: schemaString,
    type: schemaString
  }),
  event: rt.partial({
    action: schemaString,
    agent_id_status: schemaString,
    category: schemaStringArray,
    code: schemaString,
    created: schemaDate,
    dataset: schemaString,
    duration: schemaStringOrNumber,
    end: schemaDate,
    hash: schemaString,
    id: schemaString,
    ingested: schemaDate,
    kind: schemaString,
    module: schemaString,
    original: schemaString,
    outcome: schemaString,
    provider: schemaString,
    reason: schemaString,
    reference: schemaString,
    risk_score: schemaNumber,
    risk_score_norm: schemaNumber,
    sequence: schemaStringOrNumber,
    severity: schemaStringOrNumber,
    start: schemaDate,
    timezone: schemaString,
    type: schemaStringArray,
    url: schemaString
  }),
  faas: rt.partial({
    coldstart: schemaBoolean,
    execution: schemaString,
    id: schemaString,
    name: schemaString,
    version: schemaString
  }),
  file: rt.partial({
    accessed: schemaDate,
    attributes: schemaStringArray,
    code_signature: rt.partial({
      digest_algorithm: schemaString,
      exists: schemaBoolean,
      signing_id: schemaString,
      status: schemaString,
      subject_name: schemaString,
      team_id: schemaString,
      timestamp: schemaDate,
      trusted: schemaBoolean,
      valid: schemaBoolean
    }),
    created: schemaDate,
    ctime: schemaDate,
    device: schemaString,
    directory: schemaString,
    drive_letter: schemaString,
    elf: rt.partial({
      architecture: schemaString,
      byte_order: schemaString,
      cpu_type: schemaString,
      creation_date: schemaDate,
      exports: schemaUnknownArray,
      header: rt.partial({
        abi_version: schemaString,
        class: schemaString,
        data: schemaString,
        entrypoint: schemaStringOrNumber,
        object_version: schemaString,
        os_abi: schemaString,
        type: schemaString,
        version: schemaString
      }),
      imports: schemaUnknownArray,
      sections: rt.array(rt.partial({
        chi2: schemaStringOrNumber,
        entropy: schemaStringOrNumber,
        flags: schemaString,
        name: schemaString,
        physical_offset: schemaString,
        physical_size: schemaStringOrNumber,
        type: schemaString,
        virtual_address: schemaStringOrNumber,
        virtual_size: schemaStringOrNumber
      })),
      segments: rt.array(rt.partial({
        sections: schemaString,
        type: schemaString
      })),
      shared_libraries: schemaStringArray,
      telfhash: schemaString
    }),
    extension: schemaString,
    fork_name: schemaString,
    gid: schemaString,
    group: schemaString,
    hash: rt.partial({
      md5: schemaString,
      sha1: schemaString,
      sha256: schemaString,
      sha384: schemaString,
      sha512: schemaString,
      ssdeep: schemaString,
      tlsh: schemaString
    }),
    inode: schemaString,
    mime_type: schemaString,
    mode: schemaString,
    mtime: schemaDate,
    name: schemaString,
    owner: schemaString,
    path: schemaString,
    pe: rt.partial({
      architecture: schemaString,
      company: schemaString,
      description: schemaString,
      file_version: schemaString,
      imphash: schemaString,
      original_file_name: schemaString,
      pehash: schemaString,
      product: schemaString
    }),
    size: schemaStringOrNumber,
    target_path: schemaString,
    type: schemaString,
    uid: schemaString,
    x509: rt.partial({
      alternative_names: schemaStringArray,
      issuer: rt.partial({
        common_name: schemaStringArray,
        country: schemaStringArray,
        distinguished_name: schemaString,
        locality: schemaStringArray,
        organization: schemaStringArray,
        organizational_unit: schemaStringArray,
        state_or_province: schemaStringArray
      }),
      not_after: schemaDate,
      not_before: schemaDate,
      public_key_algorithm: schemaString,
      public_key_curve: schemaString,
      public_key_exponent: schemaStringOrNumber,
      public_key_size: schemaStringOrNumber,
      serial_number: schemaString,
      signature_algorithm: schemaString,
      subject: rt.partial({
        common_name: schemaStringArray,
        country: schemaStringArray,
        distinguished_name: schemaString,
        locality: schemaStringArray,
        organization: schemaStringArray,
        organizational_unit: schemaStringArray,
        state_or_province: schemaStringArray
      }),
      version_number: schemaString
    })
  }),
  group: rt.partial({
    domain: schemaString,
    id: schemaString,
    name: schemaString
  }),
  host: rt.partial({
    architecture: schemaString,
    boot: rt.partial({
      id: schemaString
    }),
    cpu: rt.partial({
      usage: schemaStringOrNumber
    }),
    disk: rt.partial({
      read: rt.partial({
        bytes: schemaStringOrNumber
      }),
      write: rt.partial({
        bytes: schemaStringOrNumber
      })
    }),
    domain: schemaString,
    geo: rt.partial({
      city_name: schemaString,
      continent_code: schemaString,
      continent_name: schemaString,
      country_iso_code: schemaString,
      country_name: schemaString,
      location: schemaGeoPoint,
      name: schemaString,
      postal_code: schemaString,
      region_iso_code: schemaString,
      region_name: schemaString,
      timezone: schemaString
    }),
    hostname: schemaString,
    id: schemaString,
    ip: schemaStringArray,
    mac: schemaStringArray,
    name: schemaString,
    network: rt.partial({
      egress: rt.partial({
        bytes: schemaStringOrNumber,
        packets: schemaStringOrNumber
      }),
      ingress: rt.partial({
        bytes: schemaStringOrNumber,
        packets: schemaStringOrNumber
      })
    }),
    os: rt.partial({
      family: schemaString,
      full: schemaString,
      kernel: schemaString,
      name: schemaString,
      platform: schemaString,
      type: schemaString,
      version: schemaString
    }),
    pid_ns_ino: schemaString,
    risk: rt.partial({
      calculated_level: schemaString,
      calculated_score: schemaNumber,
      calculated_score_norm: schemaNumber,
      static_level: schemaString,
      static_score: schemaNumber,
      static_score_norm: schemaNumber
    }),
    type: schemaString,
    uptime: schemaStringOrNumber
  }),
  http: rt.partial({
    request: rt.partial({
      body: rt.partial({
        bytes: schemaStringOrNumber,
        content: schemaString
      }),
      bytes: schemaStringOrNumber,
      id: schemaString,
      method: schemaString,
      mime_type: schemaString,
      referrer: schemaString
    }),
    response: rt.partial({
      body: rt.partial({
        bytes: schemaStringOrNumber,
        content: schemaString
      }),
      bytes: schemaStringOrNumber,
      mime_type: schemaString,
      status_code: schemaStringOrNumber
    }),
    version: schemaString
  }),
  log: rt.partial({
    file: rt.partial({
      path: schemaString
    }),
    level: schemaString,
    logger: schemaString,
    origin: rt.partial({
      file: rt.partial({
        line: schemaStringOrNumber,
        name: schemaString
      }),
      function: schemaString
    })
  }),
  message: schemaString,
  network: rt.partial({
    application: schemaString,
    bytes: schemaStringOrNumber,
    community_id: schemaString,
    direction: schemaString,
    forwarded_ip: schemaString,
    iana_number: schemaString,
    name: schemaString,
    packets: schemaStringOrNumber,
    protocol: schemaString,
    transport: schemaString,
    type: schemaString,
    vlan: rt.partial({
      id: schemaString,
      name: schemaString
    })
  }),
  observer: rt.partial({
    geo: rt.partial({
      city_name: schemaString,
      continent_code: schemaString,
      continent_name: schemaString,
      country_iso_code: schemaString,
      country_name: schemaString,
      location: schemaGeoPoint,
      name: schemaString,
      postal_code: schemaString,
      region_iso_code: schemaString,
      region_name: schemaString,
      timezone: schemaString
    }),
    hostname: schemaString,
    ip: schemaStringArray,
    mac: schemaStringArray,
    name: schemaString,
    os: rt.partial({
      family: schemaString,
      full: schemaString,
      kernel: schemaString,
      name: schemaString,
      platform: schemaString,
      type: schemaString,
      version: schemaString
    }),
    product: schemaString,
    serial_number: schemaString,
    type: schemaString,
    vendor: schemaString,
    version: schemaString
  }),
  orchestrator: rt.partial({
    api_version: schemaString,
    cluster: rt.partial({
      id: schemaString,
      name: schemaString,
      url: schemaString,
      version: schemaString
    }),
    namespace: schemaString,
    organization: schemaString,
    resource: rt.partial({
      id: schemaString,
      ip: schemaStringArray,
      name: schemaString,
      parent: rt.partial({
        type: schemaString
      }),
      type: schemaString
    }),
    type: schemaString
  }),
  organization: rt.partial({
    id: schemaString,
    name: schemaString
  }),
  package: rt.partial({
    architecture: schemaString,
    build_version: schemaString,
    checksum: schemaString,
    description: schemaString,
    install_scope: schemaString,
    installed: schemaDate,
    license: schemaString,
    name: schemaString,
    path: schemaString,
    reference: schemaString,
    size: schemaStringOrNumber,
    type: schemaString,
    version: schemaString
  }),
  process: rt.partial({
    args: schemaStringArray,
    args_count: schemaStringOrNumber,
    code_signature: rt.partial({
      digest_algorithm: schemaString,
      exists: schemaBoolean,
      signing_id: schemaString,
      status: schemaString,
      subject_name: schemaString,
      team_id: schemaString,
      timestamp: schemaDate,
      trusted: schemaBoolean,
      valid: schemaBoolean
    }),
    command_line: schemaString,
    elf: rt.partial({
      architecture: schemaString,
      byte_order: schemaString,
      cpu_type: schemaString,
      creation_date: schemaDate,
      exports: schemaUnknownArray,
      header: rt.partial({
        abi_version: schemaString,
        class: schemaString,
        data: schemaString,
        entrypoint: schemaStringOrNumber,
        object_version: schemaString,
        os_abi: schemaString,
        type: schemaString,
        version: schemaString
      }),
      imports: schemaUnknownArray,
      sections: rt.array(rt.partial({
        chi2: schemaStringOrNumber,
        entropy: schemaStringOrNumber,
        flags: schemaString,
        name: schemaString,
        physical_offset: schemaString,
        physical_size: schemaStringOrNumber,
        type: schemaString,
        virtual_address: schemaStringOrNumber,
        virtual_size: schemaStringOrNumber
      })),
      segments: rt.array(rt.partial({
        sections: schemaString,
        type: schemaString
      })),
      shared_libraries: schemaStringArray,
      telfhash: schemaString
    }),
    end: schemaDate,
    entity_id: schemaString,
    entry_leader: rt.partial({
      args: schemaStringArray,
      args_count: schemaStringOrNumber,
      attested_groups: rt.partial({
        name: schemaString
      }),
      attested_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      command_line: schemaString,
      entity_id: schemaString,
      entry_meta: rt.partial({
        source: rt.partial({
          ip: schemaString
        }),
        type: schemaString
      }),
      executable: schemaString,
      group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      interactive: schemaBoolean,
      name: schemaString,
      parent: rt.partial({
        entity_id: schemaString,
        pid: schemaStringOrNumber,
        session_leader: rt.partial({
          entity_id: schemaString,
          pid: schemaStringOrNumber,
          start: schemaDate
        }),
        start: schemaDate
      }),
      pid: schemaStringOrNumber,
      real_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      real_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      same_as_process: schemaBoolean,
      saved_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      saved_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      start: schemaDate,
      supplemental_groups: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      working_directory: schemaString
    }),
    env_vars: schemaStringArray,
    executable: schemaString,
    exit_code: schemaStringOrNumber,
    group_leader: rt.partial({
      args: schemaStringArray,
      args_count: schemaStringOrNumber,
      command_line: schemaString,
      entity_id: schemaString,
      executable: schemaString,
      group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      interactive: schemaBoolean,
      name: schemaString,
      pid: schemaStringOrNumber,
      real_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      real_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      same_as_process: schemaBoolean,
      saved_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      saved_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      start: schemaDate,
      supplemental_groups: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      working_directory: schemaString
    }),
    hash: rt.partial({
      md5: schemaString,
      sha1: schemaString,
      sha256: schemaString,
      sha384: schemaString,
      sha512: schemaString,
      ssdeep: schemaString,
      tlsh: schemaString
    }),
    interactive: schemaBoolean,
    name: schemaString,
    parent: rt.partial({
      args: schemaStringArray,
      args_count: schemaStringOrNumber,
      code_signature: rt.partial({
        digest_algorithm: schemaString,
        exists: schemaBoolean,
        signing_id: schemaString,
        status: schemaString,
        subject_name: schemaString,
        team_id: schemaString,
        timestamp: schemaDate,
        trusted: schemaBoolean,
        valid: schemaBoolean
      }),
      command_line: schemaString,
      elf: rt.partial({
        architecture: schemaString,
        byte_order: schemaString,
        cpu_type: schemaString,
        creation_date: schemaDate,
        exports: schemaUnknownArray,
        header: rt.partial({
          abi_version: schemaString,
          class: schemaString,
          data: schemaString,
          entrypoint: schemaStringOrNumber,
          object_version: schemaString,
          os_abi: schemaString,
          type: schemaString,
          version: schemaString
        }),
        imports: schemaUnknownArray,
        sections: rt.array(rt.partial({
          chi2: schemaStringOrNumber,
          entropy: schemaStringOrNumber,
          flags: schemaString,
          name: schemaString,
          physical_offset: schemaString,
          physical_size: schemaStringOrNumber,
          type: schemaString,
          virtual_address: schemaStringOrNumber,
          virtual_size: schemaStringOrNumber
        })),
        segments: rt.array(rt.partial({
          sections: schemaString,
          type: schemaString
        })),
        shared_libraries: schemaStringArray,
        telfhash: schemaString
      }),
      end: schemaDate,
      entity_id: schemaString,
      executable: schemaString,
      exit_code: schemaStringOrNumber,
      group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      group_leader: rt.partial({
        entity_id: schemaString,
        pid: schemaStringOrNumber,
        start: schemaDate
      }),
      hash: rt.partial({
        md5: schemaString,
        sha1: schemaString,
        sha256: schemaString,
        sha384: schemaString,
        sha512: schemaString,
        ssdeep: schemaString,
        tlsh: schemaString
      }),
      interactive: schemaBoolean,
      name: schemaString,
      pe: rt.partial({
        architecture: schemaString,
        company: schemaString,
        description: schemaString,
        file_version: schemaString,
        imphash: schemaString,
        original_file_name: schemaString,
        pehash: schemaString,
        product: schemaString
      }),
      pgid: schemaStringOrNumber,
      pid: schemaStringOrNumber,
      real_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      real_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      saved_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      saved_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      start: schemaDate,
      supplemental_groups: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      thread: rt.partial({
        id: schemaStringOrNumber,
        name: schemaString
      }),
      title: schemaString,
      uptime: schemaStringOrNumber,
      user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      working_directory: schemaString
    }),
    pe: rt.partial({
      architecture: schemaString,
      company: schemaString,
      description: schemaString,
      file_version: schemaString,
      imphash: schemaString,
      original_file_name: schemaString,
      pehash: schemaString,
      product: schemaString
    }),
    pgid: schemaStringOrNumber,
    pid: schemaStringOrNumber,
    previous: rt.partial({
      args: schemaStringArray,
      args_count: schemaStringOrNumber,
      executable: schemaString
    }),
    real_group: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    real_user: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    saved_group: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    saved_user: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    session_leader: rt.partial({
      args: schemaStringArray,
      args_count: schemaStringOrNumber,
      command_line: schemaString,
      entity_id: schemaString,
      executable: schemaString,
      group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      interactive: schemaBoolean,
      name: schemaString,
      parent: rt.partial({
        entity_id: schemaString,
        pid: schemaStringOrNumber,
        session_leader: rt.partial({
          entity_id: schemaString,
          pid: schemaStringOrNumber,
          start: schemaDate
        }),
        start: schemaDate
      }),
      pid: schemaStringOrNumber,
      real_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      real_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      same_as_process: schemaBoolean,
      saved_group: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      saved_user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      start: schemaDate,
      supplemental_groups: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      user: rt.partial({
        id: schemaString,
        name: schemaString
      }),
      working_directory: schemaString
    }),
    start: schemaDate,
    supplemental_groups: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    thread: rt.partial({
      id: schemaStringOrNumber,
      name: schemaString
    }),
    title: schemaString,
    uptime: schemaStringOrNumber,
    user: rt.partial({
      id: schemaString,
      name: schemaString
    }),
    working_directory: schemaString
  }),
  registry: rt.partial({
    data: rt.partial({
      bytes: schemaString,
      strings: schemaStringArray,
      type: schemaString
    }),
    hive: schemaString,
    key: schemaString,
    path: schemaString,
    value: schemaString
  }),
  related: rt.partial({
    hash: schemaStringArray,
    hosts: schemaStringArray,
    ip: schemaStringArray,
    user: schemaStringArray
  }),
  rule: rt.partial({
    author: schemaStringArray,
    category: schemaString,
    description: schemaString,
    id: schemaString,
    license: schemaString,
    name: schemaString,
    reference: schemaString,
    ruleset: schemaString,
    uuid: schemaString,
    version: schemaString
  }),
  server: rt.partial({
    address: schemaString,
    as: rt.partial({
      number: schemaStringOrNumber,
      organization: rt.partial({
        name: schemaString
      })
    }),
    bytes: schemaStringOrNumber,
    domain: schemaString,
    geo: rt.partial({
      city_name: schemaString,
      continent_code: schemaString,
      continent_name: schemaString,
      country_iso_code: schemaString,
      country_name: schemaString,
      location: schemaGeoPoint,
      name: schemaString,
      postal_code: schemaString,
      region_iso_code: schemaString,
      region_name: schemaString,
      timezone: schemaString
    }),
    ip: schemaString,
    mac: schemaString,
    nat: rt.partial({
      ip: schemaString,
      port: schemaStringOrNumber
    }),
    packets: schemaStringOrNumber,
    port: schemaStringOrNumber,
    registered_domain: schemaString,
    subdomain: schemaString,
    top_level_domain: schemaString,
    user: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    })
  }),
  service: rt.partial({
    address: schemaString,
    environment: schemaString,
    ephemeral_id: schemaString,
    id: schemaString,
    name: schemaString,
    node: rt.partial({
      name: schemaString,
      role: schemaString,
      roles: schemaStringArray
    }),
    origin: rt.partial({
      address: schemaString,
      environment: schemaString,
      ephemeral_id: schemaString,
      id: schemaString,
      name: schemaString,
      node: rt.partial({
        name: schemaString,
        role: schemaString,
        roles: schemaStringArray
      }),
      state: schemaString,
      type: schemaString,
      version: schemaString
    }),
    state: schemaString,
    target: rt.partial({
      address: schemaString,
      environment: schemaString,
      ephemeral_id: schemaString,
      id: schemaString,
      name: schemaString,
      node: rt.partial({
        name: schemaString,
        role: schemaString,
        roles: schemaStringArray
      }),
      state: schemaString,
      type: schemaString,
      version: schemaString
    }),
    type: schemaString,
    version: schemaString
  }),
  source: rt.partial({
    address: schemaString,
    as: rt.partial({
      number: schemaStringOrNumber,
      organization: rt.partial({
        name: schemaString
      })
    }),
    bytes: schemaStringOrNumber,
    domain: schemaString,
    geo: rt.partial({
      city_name: schemaString,
      continent_code: schemaString,
      continent_name: schemaString,
      country_iso_code: schemaString,
      country_name: schemaString,
      location: schemaGeoPoint,
      name: schemaString,
      postal_code: schemaString,
      region_iso_code: schemaString,
      region_name: schemaString,
      timezone: schemaString
    }),
    ip: schemaString,
    mac: schemaString,
    nat: rt.partial({
      ip: schemaString,
      port: schemaStringOrNumber
    }),
    packets: schemaStringOrNumber,
    port: schemaStringOrNumber,
    registered_domain: schemaString,
    subdomain: schemaString,
    top_level_domain: schemaString,
    user: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    })
  }),
  span: rt.partial({
    id: schemaString
  }),
  tags: schemaStringArray,
  threat: rt.partial({
    enrichments: rt.array(rt.partial({
      matched: rt.partial({
        atomic: schemaString,
        field: schemaString,
        id: schemaString,
        index: schemaString,
        occurred: schemaDate,
        type: schemaString
      })
    })),
    feed: rt.partial({
      dashboard_id: schemaString,
      description: schemaString,
      name: schemaString,
      reference: schemaString
    }),
    framework: schemaString,
    group: rt.partial({
      alias: schemaStringArray,
      id: schemaString,
      name: schemaString,
      reference: schemaString
    }),
    indicator: rt.partial({
      as: rt.partial({
        number: schemaStringOrNumber,
        organization: rt.partial({
          name: schemaString
        })
      }),
      confidence: schemaString,
      description: schemaString,
      email: rt.partial({
        address: schemaString
      }),
      file: rt.partial({
        accessed: schemaDate,
        attributes: schemaStringArray,
        code_signature: rt.partial({
          digest_algorithm: schemaString,
          exists: schemaBoolean,
          signing_id: schemaString,
          status: schemaString,
          subject_name: schemaString,
          team_id: schemaString,
          timestamp: schemaDate,
          trusted: schemaBoolean,
          valid: schemaBoolean
        }),
        created: schemaDate,
        ctime: schemaDate,
        device: schemaString,
        directory: schemaString,
        drive_letter: schemaString,
        elf: rt.partial({
          architecture: schemaString,
          byte_order: schemaString,
          cpu_type: schemaString,
          creation_date: schemaDate,
          exports: schemaUnknownArray,
          header: rt.partial({
            abi_version: schemaString,
            class: schemaString,
            data: schemaString,
            entrypoint: schemaStringOrNumber,
            object_version: schemaString,
            os_abi: schemaString,
            type: schemaString,
            version: schemaString
          }),
          imports: schemaUnknownArray,
          sections: rt.array(rt.partial({
            chi2: schemaStringOrNumber,
            entropy: schemaStringOrNumber,
            flags: schemaString,
            name: schemaString,
            physical_offset: schemaString,
            physical_size: schemaStringOrNumber,
            type: schemaString,
            virtual_address: schemaStringOrNumber,
            virtual_size: schemaStringOrNumber
          })),
          segments: rt.array(rt.partial({
            sections: schemaString,
            type: schemaString
          })),
          shared_libraries: schemaStringArray,
          telfhash: schemaString
        }),
        extension: schemaString,
        fork_name: schemaString,
        gid: schemaString,
        group: schemaString,
        hash: rt.partial({
          md5: schemaString,
          sha1: schemaString,
          sha256: schemaString,
          sha384: schemaString,
          sha512: schemaString,
          ssdeep: schemaString,
          tlsh: schemaString
        }),
        inode: schemaString,
        mime_type: schemaString,
        mode: schemaString,
        mtime: schemaDate,
        name: schemaString,
        owner: schemaString,
        path: schemaString,
        pe: rt.partial({
          architecture: schemaString,
          company: schemaString,
          description: schemaString,
          file_version: schemaString,
          imphash: schemaString,
          original_file_name: schemaString,
          pehash: schemaString,
          product: schemaString
        }),
        size: schemaStringOrNumber,
        target_path: schemaString,
        type: schemaString,
        uid: schemaString,
        x509: rt.partial({
          alternative_names: schemaStringArray,
          issuer: rt.partial({
            common_name: schemaStringArray,
            country: schemaStringArray,
            distinguished_name: schemaString,
            locality: schemaStringArray,
            organization: schemaStringArray,
            organizational_unit: schemaStringArray,
            state_or_province: schemaStringArray
          }),
          not_after: schemaDate,
          not_before: schemaDate,
          public_key_algorithm: schemaString,
          public_key_curve: schemaString,
          public_key_exponent: schemaStringOrNumber,
          public_key_size: schemaStringOrNumber,
          serial_number: schemaString,
          signature_algorithm: schemaString,
          subject: rt.partial({
            common_name: schemaStringArray,
            country: schemaStringArray,
            distinguished_name: schemaString,
            locality: schemaStringArray,
            organization: schemaStringArray,
            organizational_unit: schemaStringArray,
            state_or_province: schemaStringArray
          }),
          version_number: schemaString
        })
      }),
      first_seen: schemaDate,
      geo: rt.partial({
        city_name: schemaString,
        continent_code: schemaString,
        continent_name: schemaString,
        country_iso_code: schemaString,
        country_name: schemaString,
        location: schemaGeoPoint,
        name: schemaString,
        postal_code: schemaString,
        region_iso_code: schemaString,
        region_name: schemaString,
        timezone: schemaString
      }),
      ip: schemaString,
      last_seen: schemaDate,
      marking: rt.partial({
        tlp: schemaString,
        tlp_version: schemaString
      }),
      modified_at: schemaDate,
      port: schemaStringOrNumber,
      provider: schemaString,
      reference: schemaString,
      registry: rt.partial({
        data: rt.partial({
          bytes: schemaString,
          strings: schemaStringArray,
          type: schemaString
        }),
        hive: schemaString,
        key: schemaString,
        path: schemaString,
        value: schemaString
      }),
      scanner_stats: schemaStringOrNumber,
      sightings: schemaStringOrNumber,
      type: schemaString,
      url: rt.partial({
        domain: schemaString,
        extension: schemaString,
        fragment: schemaString,
        full: schemaString,
        original: schemaString,
        password: schemaString,
        path: schemaString,
        port: schemaStringOrNumber,
        query: schemaString,
        registered_domain: schemaString,
        scheme: schemaString,
        subdomain: schemaString,
        top_level_domain: schemaString,
        username: schemaString
      }),
      x509: rt.partial({
        alternative_names: schemaStringArray,
        issuer: rt.partial({
          common_name: schemaStringArray,
          country: schemaStringArray,
          distinguished_name: schemaString,
          locality: schemaStringArray,
          organization: schemaStringArray,
          organizational_unit: schemaStringArray,
          state_or_province: schemaStringArray
        }),
        not_after: schemaDate,
        not_before: schemaDate,
        public_key_algorithm: schemaString,
        public_key_curve: schemaString,
        public_key_exponent: schemaStringOrNumber,
        public_key_size: schemaStringOrNumber,
        serial_number: schemaString,
        signature_algorithm: schemaString,
        subject: rt.partial({
          common_name: schemaStringArray,
          country: schemaStringArray,
          distinguished_name: schemaString,
          locality: schemaStringArray,
          organization: schemaStringArray,
          organizational_unit: schemaStringArray,
          state_or_province: schemaStringArray
        }),
        version_number: schemaString
      })
    }),
    software: rt.partial({
      alias: schemaStringArray,
      id: schemaString,
      name: schemaString,
      platforms: schemaStringArray,
      reference: schemaString,
      type: schemaString
    }),
    tactic: rt.partial({
      id: schemaStringArray,
      name: schemaStringArray,
      reference: schemaStringArray
    }),
    technique: rt.partial({
      id: schemaStringArray,
      name: schemaStringArray,
      reference: schemaStringArray,
      subtechnique: rt.partial({
        id: schemaStringArray,
        name: schemaStringArray,
        reference: schemaStringArray
      })
    })
  }),
  tls: rt.partial({
    cipher: schemaString,
    client: rt.partial({
      certificate: schemaString,
      certificate_chain: schemaStringArray,
      hash: rt.partial({
        md5: schemaString,
        sha1: schemaString,
        sha256: schemaString
      }),
      issuer: schemaString,
      ja3: schemaString,
      not_after: schemaDate,
      not_before: schemaDate,
      server_name: schemaString,
      subject: schemaString,
      supported_ciphers: schemaStringArray,
      x509: rt.partial({
        alternative_names: schemaStringArray,
        issuer: rt.partial({
          common_name: schemaStringArray,
          country: schemaStringArray,
          distinguished_name: schemaString,
          locality: schemaStringArray,
          organization: schemaStringArray,
          organizational_unit: schemaStringArray,
          state_or_province: schemaStringArray
        }),
        not_after: schemaDate,
        not_before: schemaDate,
        public_key_algorithm: schemaString,
        public_key_curve: schemaString,
        public_key_exponent: schemaStringOrNumber,
        public_key_size: schemaStringOrNumber,
        serial_number: schemaString,
        signature_algorithm: schemaString,
        subject: rt.partial({
          common_name: schemaStringArray,
          country: schemaStringArray,
          distinguished_name: schemaString,
          locality: schemaStringArray,
          organization: schemaStringArray,
          organizational_unit: schemaStringArray,
          state_or_province: schemaStringArray
        }),
        version_number: schemaString
      })
    }),
    curve: schemaString,
    established: schemaBoolean,
    next_protocol: schemaString,
    resumed: schemaBoolean,
    server: rt.partial({
      certificate: schemaString,
      certificate_chain: schemaStringArray,
      hash: rt.partial({
        md5: schemaString,
        sha1: schemaString,
        sha256: schemaString
      }),
      issuer: schemaString,
      ja3s: schemaString,
      not_after: schemaDate,
      not_before: schemaDate,
      subject: schemaString,
      x509: rt.partial({
        alternative_names: schemaStringArray,
        issuer: rt.partial({
          common_name: schemaStringArray,
          country: schemaStringArray,
          distinguished_name: schemaString,
          locality: schemaStringArray,
          organization: schemaStringArray,
          organizational_unit: schemaStringArray,
          state_or_province: schemaStringArray
        }),
        not_after: schemaDate,
        not_before: schemaDate,
        public_key_algorithm: schemaString,
        public_key_curve: schemaString,
        public_key_exponent: schemaStringOrNumber,
        public_key_size: schemaStringOrNumber,
        serial_number: schemaString,
        signature_algorithm: schemaString,
        subject: rt.partial({
          common_name: schemaStringArray,
          country: schemaStringArray,
          distinguished_name: schemaString,
          locality: schemaStringArray,
          organization: schemaStringArray,
          organizational_unit: schemaStringArray,
          state_or_province: schemaStringArray
        }),
        version_number: schemaString
      })
    }),
    version: schemaString,
    version_protocol: schemaString
  }),
  trace: rt.partial({
    id: schemaString
  }),
  transaction: rt.partial({
    id: schemaString
  }),
  url: rt.partial({
    domain: schemaString,
    extension: schemaString,
    fragment: schemaString,
    full: schemaString,
    original: schemaString,
    password: schemaString,
    path: schemaString,
    port: schemaStringOrNumber,
    query: schemaString,
    registered_domain: schemaString,
    scheme: schemaString,
    subdomain: schemaString,
    top_level_domain: schemaString,
    username: schemaString
  }),
  user: rt.partial({
    changes: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    }),
    domain: schemaString,
    effective: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    }),
    email: schemaString,
    full_name: schemaString,
    group: rt.partial({
      domain: schemaString,
      id: schemaString,
      name: schemaString
    }),
    hash: schemaString,
    id: schemaString,
    name: schemaString,
    risk: rt.partial({
      calculated_level: schemaString,
      calculated_score: schemaNumber,
      calculated_score_norm: schemaNumber,
      static_level: schemaString,
      static_score: schemaNumber,
      static_score_norm: schemaNumber
    }),
    roles: schemaStringArray,
    target: rt.partial({
      domain: schemaString,
      email: schemaString,
      full_name: schemaString,
      group: rt.partial({
        domain: schemaString,
        id: schemaString,
        name: schemaString
      }),
      hash: schemaString,
      id: schemaString,
      name: schemaString,
      roles: schemaStringArray
    })
  }),
  user_agent: rt.partial({
    device: rt.partial({
      name: schemaString
    }),
    name: schemaString,
    original: schemaString,
    os: rt.partial({
      family: schemaString,
      full: schemaString,
      kernel: schemaString,
      name: schemaString,
      platform: schemaString,
      type: schemaString,
      version: schemaString
    }),
    version: schemaString
  }),
  vulnerability: rt.partial({
    category: schemaStringArray,
    classification: schemaString,
    description: schemaString,
    enumeration: schemaString,
    id: schemaString,
    reference: schemaString,
    report_id: schemaString,
    scanner: rt.partial({
      vendor: schemaString
    }),
    score: rt.partial({
      base: schemaNumber,
      environmental: schemaNumber,
      temporal: schemaNumber,
      version: schemaString
    }),
    severity: schemaString
  })
});

// prettier-ignore
const EcsSchema = rt.intersection([EcsRequired, EcsOptional]);
// prettier-ignore
exports.EcsSchema = EcsSchema;