"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsClientFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _rules_settings_client = require("./rules_settings_client");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RulesSettingsClientFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "isInitialized", false);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsService", void 0);
    (0, _defineProperty2.default)(this, "securityPluginStart", void 0);
  }
  initialize(options) {
    if (this.isInitialized) {
      throw new Error('RulesSettingsClientFactory already initialized');
    }
    this.isInitialized = true;
    this.logger = options.logger;
    this.savedObjectsService = options.savedObjectsService;
    this.securityPluginStart = options.securityPluginStart;
  }
  createRulesSettingsClient(request, withAuth) {
    const {
      securityPluginStart
    } = this;
    const savedObjectsClient = this.savedObjectsService.getScopedClient(request, {
      includedHiddenTypes: [_common.RULES_SETTINGS_SAVED_OBJECT_TYPE],
      ...(withAuth ? {} : {
        excludedExtensions: [_server.SECURITY_EXTENSION_ID]
      })
    });
    return new _rules_settings_client.RulesSettingsClient({
      logger: this.logger,
      savedObjectsClient,
      async getUserName() {
        if (!securityPluginStart || !request) {
          return null;
        }
        const user = securityPluginStart.authc.getCurrentUser(request);
        return user ? user.username : null;
      }
    });
  }
  createWithAuthorization(request) {
    return this.createRulesSettingsClient(request, true);
  }
  create(request) {
    return this.createRulesSettingsClient(request, false);
  }
}
exports.RulesSettingsClientFactory = RulesSettingsClientFactory;