"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.incrementRevision = incrementRevision;
var _lodash = require("lodash");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function incrementRevision(currentRule, {
  data
}, updatedParams) {
  // Diff root level attrs
  for (const [field, value] of Object.entries(data).filter(([key]) => key !== 'params')) {
    if (!_.fieldsToExcludeFromRevisionUpdates.has(field) && !(0, _lodash.isEqual)(value, (0, _lodash.get)(currentRule.attributes, field))) {
      return currentRule.attributes.revision + 1;
    }
  }

  // Diff rule params
  for (const [field, value] of Object.entries(updatedParams)) {
    if (!_.fieldsToExcludeFromRevisionUpdates.has(field) && !(0, _lodash.isEqual)(value, (0, _lodash.get)(currentRule.attributes.params, field))) {
      return currentRule.attributes.revision + 1;
    }
  }
  return currentRule.attributes.revision;
}