"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRecoveredAlert = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _strip_framework_fields = require("./strip_framework_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates an active alert document to recovered
 * Currently only populates framework fields and not any rule type specific fields
 */

const buildRecoveredAlert = ({
  alert,
  legacyAlert,
  rule,
  timestamp,
  payload,
  recoveryActionGroup
}) => {
  var _rule$kibana, _rule$kibana2;
  const cleanedPayload = payload ? (0, _strip_framework_fields.stripFrameworkFields)(payload) : {};
  return _deepmerge.default.all([alert, cleanedPayload, {
    // Update the timestamp to reflect latest update time
    '@timestamp': timestamp,
    kibana: {
      alert: {
        // Set the recovery action group
        action_group: recoveryActionGroup,
        // Set latest flapping state
        flapping: legacyAlert.getFlapping(),
        // Set latest flapping_history
        flapping_history: legacyAlert.getFlappingHistory(),
        // Set latest maintenance window IDs
        maintenance_window_ids: legacyAlert.getMaintenanceWindowIds(),
        // Set latest rule configuration
        rule: (_rule$kibana = rule.kibana) === null || _rule$kibana === void 0 ? void 0 : _rule$kibana.alert.rule,
        // Set status to 'recovered'
        status: 'recovered',
        // Set latest duration as recovered alerts should have updated duration
        ...(legacyAlert.getState().duration ? {
          duration: {
            us: legacyAlert.getState().duration
          }
        } : {}),
        // Set end time
        ...(legacyAlert.getState().end ? {
          end: legacyAlert.getState().end
        } : {})

        // Fields that are explicitly not updated:
        // instance.id
        // action_group
        // uuid - recovered alerts should carry over previous UUID
        // start - recovered alerts should keep the initial start time
      },

      space_ids: (_rule$kibana2 = rule.kibana) === null || _rule$kibana2 === void 0 ? void 0 : _rule$kibana2.space_ids
    }
  }], {
    arrayMerge: (_, sourceArray) => sourceArray
  });
};
exports.buildRecoveredAlert = buildRecoveredAlert;