"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildOngoingAlert = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _strip_framework_fields = require("./strip_framework_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates an existing alert document with data from the LegacyAlert class
 * Currently only populates framework fields and not any rule type specific fields
 */

const buildOngoingAlert = ({
  alert,
  legacyAlert,
  payload,
  rule,
  timestamp
}) => {
  var _legacyAlert$getSched, _rule$kibana, _rule$kibana2;
  const cleanedPayload = payload ? (0, _strip_framework_fields.stripFrameworkFields)(payload) : {};
  return _deepmerge.default.all([alert, cleanedPayload, {
    // Update the timestamp to reflect latest update time
    '@timestamp': timestamp,
    kibana: {
      alert: {
        // Because we're building this alert after the action execution handler has been
        // run, the scheduledExecutionOptions for the alert has been cleared and
        // the lastScheduledActions has been set. If we ever change the order of operations
        // to build and persist the alert before action execution handler, we will need to
        // update where we pull the action group from.
        // Set latest action group as this may have changed during execution (ex: error -> warning)
        action_group: (_legacyAlert$getSched = legacyAlert.getScheduledActionOptions()) === null || _legacyAlert$getSched === void 0 ? void 0 : _legacyAlert$getSched.actionGroup,
        // Set latest flapping state
        flapping: legacyAlert.getFlapping(),
        // Set latest flapping_history
        flapping_history: legacyAlert.getFlappingHistory(),
        // Set latest maintenance window IDs
        maintenance_window_ids: legacyAlert.getMaintenanceWindowIds(),
        // Set latest rule configuration
        rule: (_rule$kibana = rule.kibana) === null || _rule$kibana === void 0 ? void 0 : _rule$kibana.alert.rule,
        // Set latest duration as ongoing alerts should have updated duration
        ...(legacyAlert.getState().duration ? {
          duration: {
            us: legacyAlert.getState().duration
          }
        } : {})
        // Fields that are explicitly not updated:
        // instance.id
        // status - ongoing alerts should maintain 'active' status
        // uuid - ongoing alerts should carry over previous UUID
        // start - ongoing alerts should keep the initial start time
      },

      space_ids: (_rule$kibana2 = rule.kibana) === null || _rule$kibana2 === void 0 ? void 0 : _rule$kibana2.space_ids
    }
  }], {
    arrayMerge: (_, sourceArray) => sourceArray
  });
};
exports.buildOngoingAlert = buildOngoingAlert;