"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildNewAlert = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _strip_framework_fields = require("./strip_framework_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Builds a new alert document from the LegacyAlert class
 * Currently only populates framework fields and not any rule type specific fields
 */

const buildNewAlert = ({
  legacyAlert,
  rule,
  timestamp,
  payload
}) => {
  var _legacyAlert$getSched, _rule$kibana, _rule$kibana2;
  const cleanedPayload = payload ? (0, _strip_framework_fields.stripFrameworkFields)(payload) : {};
  return _deepmerge.default.all([cleanedPayload, {
    '@timestamp': timestamp,
    kibana: {
      alert: {
        action_group: (_legacyAlert$getSched = legacyAlert.getScheduledActionOptions()) === null || _legacyAlert$getSched === void 0 ? void 0 : _legacyAlert$getSched.actionGroup,
        flapping: legacyAlert.getFlapping(),
        flapping_history: legacyAlert.getFlappingHistory(),
        instance: {
          id: legacyAlert.getId()
        },
        maintenance_window_ids: legacyAlert.getMaintenanceWindowIds(),
        rule: (_rule$kibana = rule.kibana) === null || _rule$kibana === void 0 ? void 0 : _rule$kibana.alert.rule,
        status: 'active',
        uuid: legacyAlert.getUuid(),
        ...(legacyAlert.getState().duration ? {
          duration: {
            us: legacyAlert.getState().duration
          }
        } : {}),
        ...(legacyAlert.getState().start ? {
          start: legacyAlert.getState().start
        } : {})
      },
      space_ids: (_rule$kibana2 = rule.kibana) === null || _rule$kibana2 === void 0 ? void 0 : _rule$kibana2.space_ids
    }
  }], {
    arrayMerge: (_, sourceArray) => sourceArray
  });
};
exports.buildNewAlert = buildNewAlert;