"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiopsPlugin = void 0;
var _rxjs = require("rxjs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class AiopsPlugin {
  setup() {
    return {};
  }
  start(core, plugins) {
    // importing async to keep the aiops plugin size to a minimum
    Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/ui-actions-plugin/public'))), Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_categorization'))), (0, _rxjs.firstValueFrom)(plugins.licensing.license$)]).then(([uiActionsImports, {
      categorizeFieldAction
    }, license]) => {
      if (license.hasAtLeast('platinum')) {
        const {
          ACTION_CATEGORIZE_FIELD,
          CATEGORIZE_FIELD_TRIGGER
        } = uiActionsImports;
        if (plugins.uiActions.hasAction(ACTION_CATEGORIZE_FIELD)) {
          plugins.uiActions.unregisterAction(ACTION_CATEGORIZE_FIELD);
        }
        plugins.uiActions.addTriggerAction(CATEGORIZE_FIELD_TRIGGER, categorizeFieldAction(core, plugins));
      }
    });
    return {};
  }
  stop() {}
}
exports.AiopsPlugin = AiopsPlugin;