"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpikeAnalysisTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_eui_theme = require("../../hooks/use_eui_theme");
var _mini_histogram = require("../mini_histogram");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _get_failed_transactions_correlation_impact_label = require("./get_failed_transactions_correlation_impact_label");
var _spike_analysis_table_row_provider = require("./spike_analysis_table_row_provider");
var _field_stats_popover = require("../field_stats_popover");
var _use_copy_to_clipboard_action = require("./use_copy_to_clipboard_action");
var _use_view_in_discover_action = require("./use_view_in_discover_action");
var _use_view_in_log_pattern_analysis_action = require("./use_view_in_log_pattern_analysis_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NARROW_COLUMN_WIDTH = '120px';
const ACTIONS_COLUMN_WIDTH = '60px';
const UNIQUE_COLUMN_WIDTH = '40px';
const NOT_AVAILABLE = '--';
const PAGINATION_SIZE_OPTIONS = [5, 10, 20, 50];
const DEFAULT_SORT_FIELD = 'pValue';
const DEFAULT_SORT_DIRECTION = 'asc';
const SpikeAnalysisTable = ({
  significantTerms,
  dataView,
  loading,
  isExpandedRow,
  searchQuery,
  timeRangeMs,
  barColorOverride,
  barHighlightColorOverride
}) => {
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  const primaryBackgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const dataViewId = dataView.id;
  const {
    pinnedSignificantTerm,
    selectedSignificantTerm,
    setPinnedSignificantTerm,
    setSelectedSignificantTerm
  } = (0, _spike_analysis_table_row_provider.useSpikeAnalysisTableRowContext)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const fieldStatsServices = (0, _react.useMemo)(() => {
    return {
      uiSettings,
      dataViews: data.dataViews,
      data,
      fieldFormats,
      charts
    };
  }, [uiSettings, data, fieldFormats, charts]);
  const copyToClipBoardAction = (0, _use_copy_to_clipboard_action.useCopyToClipboardAction)();
  const viewInDiscoverAction = (0, _use_view_in_discover_action.useViewInDiscoverAction)(dataViewId);
  const viewInLogPatternAnalysisAction = (0, _use_view_in_log_pattern_analysis_action.useViewInLogPatternAnalysisAction)(dataViewId);
  const columns = [{
    'data-test-subj': 'aiopsSpikeAnalysisTableColumnFieldName',
    field: 'fieldName',
    name: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.fieldNameLabel', {
      defaultMessage: 'Field name'
    }),
    render: (_, {
      fieldName,
      fieldValue
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_stats_popover.FieldStatsPopover, {
      dataView: dataView,
      fieldName: fieldName,
      fieldValue: fieldValue,
      fieldStatsServices: fieldStatsServices,
      dslQuery: searchQuery,
      timeRangeMs: timeRangeMs
    }), fieldName),
    sortable: true,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsSpikeAnalysisTableColumnFieldValue',
    field: 'fieldValue',
    name: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.fieldValueLabel', {
      defaultMessage: 'Field value'
    }),
    render: (_, {
      fieldValue
    }) => String(fieldValue),
    sortable: true,
    textOnly: true,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsSpikeAnalysisTableColumnLogRate',
    width: NARROW_COLUMN_WIDTH,
    field: 'pValue',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.logRateColumnTooltip', {
        defaultMessage: 'A visual representation of the impact of the field on the message rate difference'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.logRateLabel",
      defaultMessage: "Log rate"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    render: (_, {
      histogram,
      fieldName,
      fieldValue
    }) => /*#__PURE__*/_react.default.createElement(_mini_histogram.MiniHistogram, {
      chartData: histogram,
      isLoading: loading && histogram === undefined,
      label: `${fieldName}:${fieldValue}`,
      barColorOverride: barColorOverride,
      barHighlightColorOverride: barHighlightColorOverride
    }),
    sortable: false,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsSpikeAnalysisTableColumnDocCount',
    width: NARROW_COLUMN_WIDTH,
    field: 'doc_count',
    name: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.docCountLabel', {
      defaultMessage: 'Doc count'
    }),
    sortable: true,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsSpikeAnalysisTableColumnPValue',
    width: NARROW_COLUMN_WIDTH,
    field: 'pValue',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.pValueColumnTooltip', {
        defaultMessage: 'The significance of changes in the frequency of values; lower values indicate greater change; sorting this column will automatically do a secondary sort on the doc count column.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.pValueLabel",
      defaultMessage: "p-value"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    render: pValue => {
      var _pValue$toPrecision;
      return (_pValue$toPrecision = pValue === null || pValue === void 0 ? void 0 : pValue.toPrecision(3)) !== null && _pValue$toPrecision !== void 0 ? _pValue$toPrecision : NOT_AVAILABLE;
    },
    sortable: true,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiopsSpikeAnalysisTableColumnImpact',
    width: NARROW_COLUMN_WIDTH,
    field: 'pValue',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.impactLabelColumnTooltip', {
        defaultMessage: 'The level of impact of the field on the message rate difference.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.impactLabel",
      defaultMessage: "Impact"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    render: (_, {
      pValue
    }) => {
      if (!pValue) return NOT_AVAILABLE;
      const label = (0, _get_failed_transactions_correlation_impact_label.getFailedTransactionsCorrelationImpactLabel)(pValue);
      return label ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: label.color
      }, label.impact) : null;
    },
    sortable: true,
    valign: 'middle'
  }, {
    'data-test-subj': 'aiOpsSpikeAnalysisTableColumnAction',
    name: _i18n.i18n.translate('xpack.aiops.spikeAnalysisTable.actionsColumnName', {
      defaultMessage: 'Actions'
    }),
    actions: [...(viewInDiscoverAction ? [viewInDiscoverAction] : []), ...(viewInLogPatternAnalysisAction ? [viewInLogPatternAnalysisAction] : []), copyToClipBoardAction],
    width: ACTIONS_COLUMN_WIDTH,
    valign: 'middle'
  }];
  if (isExpandedRow === true) {
    columns.unshift({
      'data-test-subj': 'aiopsSpikeAnalysisTableColumnUnique',
      width: UNIQUE_COLUMN_WIDTH,
      field: 'unique',
      name: '',
      render: (_, {
        unique
      }) => {
        if (unique) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            content: _i18n.i18n.translate('xpack.aiops.explainLogRateSpikes.spikeAnalysisTable.uniqueColumnTooltip', {
              defaultMessage: 'This field/value pair only appears in this group'
            }),
            position: "top",
            type: "asterisk"
          });
        }
        return '';
      },
      sortable: false,
      valign: 'middle'
    });
  }
  const onChange = (0, _react.useCallback)(tableSettings => {
    if (tableSettings.page) {
      const {
        index,
        size
      } = tableSettings.page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (tableSettings.sort) {
      const {
        field,
        direction
      } = tableSettings.sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const {
    pagination,
    pageOfItems,
    sorting
  } = (0, _react.useMemo)(() => {
    var _significantTerms$len;
    const pageStart = pageIndex * pageSize;
    const itemCount = (_significantTerms$len = significantTerms === null || significantTerms === void 0 ? void 0 : significantTerms.length) !== null && _significantTerms$len !== void 0 ? _significantTerms$len : 0;
    let items = significantTerms !== null && significantTerms !== void 0 ? significantTerms : [];
    const sortIteratees = [item => {
      if (item && typeof item[sortField] === 'string') {
        // @ts-ignore Object is possibly null or undefined
        return item[sortField].toLowerCase();
      }
      return item[sortField];
    }];
    const sortDirections = [sortDirection];

    // Only if the table is sorted by p-value, add a secondary sort by doc count.
    if (sortField === 'pValue') {
      sortIteratees.push(item => item.doc_count);
      sortDirections.push(sortDirection);
    }
    items = (0, _lodash.orderBy)(significantTerms, sortIteratees, sortDirections);
    return {
      pageOfItems: items.slice(pageStart, pageStart + pageSize),
      pagination: {
        pageIndex,
        pageSize,
        totalItemCount: itemCount,
        pageSizeOptions: PAGINATION_SIZE_OPTIONS
      },
      sorting: {
        sort: {
          field: sortField,
          direction: sortDirection
        }
      }
    };
  }, [pageIndex, pageSize, sortField, sortDirection, significantTerms]);
  const getRowStyle = significantTerm => {
    if (pinnedSignificantTerm && pinnedSignificantTerm.fieldName === significantTerm.fieldName && pinnedSignificantTerm.fieldValue === significantTerm.fieldValue) {
      return {
        backgroundColor: primaryBackgroundColor
      };
    }
    if (selectedSignificantTerm && selectedSignificantTerm.fieldName === significantTerm.fieldName && selectedSignificantTerm.fieldValue === significantTerm.fieldValue) {
      return {
        backgroundColor: euiTheme.euiColorLightestShade
      };
    }
    return {
      backgroundColor: euiTheme.euiColorEmptyShade
    };
  };

  // Don't pass on the `loading` state to the table itself because
  // it disables hovering events. Because the mini histograms take a while
  // to load, hovering would not update the main chart. Instead,
  // the loading state is shown by the progress bar on the outer component level.
  // The outer component also will display a prompt when no data was returned
  // running the analysis and will hide this table.

  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "aiopsSpikeAnalysisTable",
    compressed: true,
    columns: columns,
    items: pageOfItems,
    onChange: onChange,
    pagination: pagination.totalItemCount > pagination.pageSize ? pagination : undefined,
    loading: false,
    sorting: sorting,
    rowProps: significantTerm => {
      return {
        'data-test-subj': `aiopsSpikeAnalysisTableRow row-${significantTerm.fieldName}-${significantTerm.fieldValue}`,
        onClick: () => {
          if (significantTerm.fieldName === (pinnedSignificantTerm === null || pinnedSignificantTerm === void 0 ? void 0 : pinnedSignificantTerm.fieldName) && significantTerm.fieldValue === (pinnedSignificantTerm === null || pinnedSignificantTerm === void 0 ? void 0 : pinnedSignificantTerm.fieldValue)) {
            setPinnedSignificantTerm(null);
          } else {
            setPinnedSignificantTerm(significantTerm);
          }
        },
        onMouseEnter: () => {
          setSelectedSignificantTerm(significantTerm);
        },
        onMouseLeave: () => {
          setSelectedSignificantTerm(null);
        },
        style: getRowStyle(significantTerm)
      };
    }
  });
};
exports.SpikeAnalysisTable = SpikeAnalysisTable;