"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _aiopsComponents = require("@kbn/aiops-components");
var _aiopsUtils = require("@kbn/aiops-utils");
var _common = require("@kbn/charts-plugin/common");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _brush_badge = require("./brush_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPEC_ID = 'document_count';
const BADGE_HEIGHT = 20;
const BADGE_WIDTH = 75;
var VIEW_MODE;
(function (VIEW_MODE) {
  VIEW_MODE["ZOOM"] = "zoom";
  VIEW_MODE["BRUSH"] = "brush";
})(VIEW_MODE || (VIEW_MODE = {}));
function getTimezone(uiSettings) {
  if (uiSettings.isDefault('dateFormat:tz')) {
    const detectedTimezone = _moment.default.tz.guess();
    if (detectedTimezone) return detectedTimezone;else return (0, _moment.default)().format('Z');
  } else {
    return uiSettings.get('dateFormat:tz', 'Browser');
  }
}
function getBaselineBadgeOverflow(windowParametersAsPixels, baselineBadgeWidth) {
  const {
    baselineMin,
    baselineMax,
    deviationMin
  } = windowParametersAsPixels;
  const baselineBrushWidth = baselineMax - baselineMin;
  const baselineBadgeActualMax = baselineMin + baselineBadgeWidth;
  return deviationMin < baselineBadgeActualMax ? Math.max(0, baselineBadgeWidth - baselineBrushWidth) : 0;
}
const DocumentCountChart = ({
  brushSelectionUpdateHandler,
  width,
  chartPoints,
  chartPointsSplit,
  timeRangeEarliest,
  timeRangeLatest,
  interval,
  chartPointsSplitLabel,
  isBrushCleared,
  autoAnalysisStart,
  barColorOverride,
  barHighlightColorOverride
}) => {
  var _windowParametersAsPi, _windowParametersAsPi2, _window$_echDebugStat;
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const chartTheme = charts.theme.useChartsTheme();
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const xAxisFormatter = fieldFormats.deserialize({
    id: 'date'
  });
  const useLegacyTimeAxis = uiSettings.get('visualization:useLegacyTimeAxis', false);
  const overallSeriesName = _i18n.i18n.translate('xpack.aiops.dataGrid.field.documentCountChart.seriesLabel', {
    defaultMessage: 'document count'
  });
  const overallSeriesNameWithSplit = _i18n.i18n.translate('xpack.aiops.dataGrid.field.documentCountChartSplit.seriesLabel', {
    defaultMessage: 'Other document count'
  });

  // TODO Let user choose between ZOOM and BRUSH mode.
  const [viewMode] = (0, _react.useState)(VIEW_MODE.BRUSH);
  const hasNoData = (0, _react.useMemo)(() => (chartPoints === undefined || chartPoints.length < 1) && (chartPointsSplit === undefined || Array.isArray(chartPointsSplit) && chartPointsSplit.length < 1), [chartPoints, chartPointsSplit]);
  const adjustedChartPoints = (0, _react.useMemo)(() => {
    // Display empty chart when no data in range and no split data to show
    if (hasNoData) return [{
      time: timeRangeEarliest,
      value: 0
    }];

    // If chart has only one bucket
    // it won't show up correctly unless we add an extra data point
    if (chartPoints.length === 1) {
      return [...chartPoints, {
        time: interval ? Number(chartPoints[0].time) + interval : timeRangeEarliest,
        value: 0
      }];
    }
    return chartPoints;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartPoints, timeRangeEarliest, timeRangeLatest, interval]);
  const adjustedChartPointsSplit = (0, _react.useMemo)(() => {
    // Display empty chart when no data in range
    if (hasNoData) return [{
      time: timeRangeEarliest,
      value: 0
    }];

    // If chart has only one bucket
    // it won't show up correctly unless we add an extra data point
    if (Array.isArray(chartPointsSplit) && chartPointsSplit.length === 1) {
      return [...chartPointsSplit, {
        time: interval ? Number(chartPointsSplit[0].time) + interval : timeRangeEarliest,
        value: 0
      }];
    }
    return chartPointsSplit;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartPointsSplit, timeRangeEarliest, timeRangeLatest, interval]);
  const snapTimestamps = (0, _react.useMemo)(() => {
    const timestamps = [];
    let n = timeRangeEarliest;
    while (n <= timeRangeLatest + interval) {
      timestamps.push(n);
      n += interval;
    }
    return timestamps;
  }, [timeRangeEarliest, timeRangeLatest, interval]);
  const timefilterUpdateHandler = (0, _react.useCallback)(range => {
    data.query.timefilter.timefilter.setTime({
      from: (0, _moment.default)(range.from).toISOString(),
      to: (0, _moment.default)(range.to).toISOString(),
      mode: 'absolute'
    });
  }, [data]);
  const onBrushEnd = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [from, to] = x;
    timefilterUpdateHandler({
      from,
      to
    });
  };
  const timeZone = getTimezone(uiSettings);
  const [originalWindowParameters, setOriginalWindowParameters] = (0, _react.useState)();
  const [windowParameters, setWindowParameters] = (0, _react.useState)();
  const [windowParametersAsPixels, setWindowParametersAsPixels] = (0, _react.useState)();
  const triggerAnalysis = (0, _react.useCallback)(startRange => {
    if (viewMode === VIEW_MODE.ZOOM && typeof startRange === 'number') {
      const range = {
        from: startRange,
        to: startRange + interval
      };
      timefilterUpdateHandler(range);
    } else if (viewMode === VIEW_MODE.BRUSH) {
      if (originalWindowParameters === undefined && windowParameters === undefined && adjustedChartPoints !== undefined) {
        const wp = typeof startRange === 'number' ? (0, _aiopsUtils.getWindowParameters)(startRange + interval / 2, timeRangeEarliest, timeRangeLatest + interval) : startRange;
        const wpSnap = (0, _aiopsUtils.getSnappedWindowParameters)(wp, snapTimestamps);
        setOriginalWindowParameters(wpSnap);
        setWindowParameters(wpSnap);
        if (brushSelectionUpdateHandler !== undefined) {
          brushSelectionUpdateHandler(wpSnap, true);
        }
      }
    }
  }, [interval, timeRangeEarliest, timeRangeLatest, snapTimestamps, originalWindowParameters, setWindowParameters, brushSelectionUpdateHandler, adjustedChartPoints, timefilterUpdateHandler, viewMode, windowParameters]);
  const onElementClick = (0, _react.useCallback)(([elementData]) => {
    if (brushSelectionUpdateHandler === undefined) {
      return;
    }
    const startRange = elementData[0].x;
    triggerAnalysis(startRange);
  }, [triggerAnalysis, brushSelectionUpdateHandler]);
  (0, _react.useEffect)(() => {
    if (autoAnalysisStart !== undefined) {
      triggerAnalysis(autoAnalysisStart);
    }
  }, [triggerAnalysis, autoAnalysisStart]);
  (0, _react.useEffect)(() => {
    if (isBrushCleared && originalWindowParameters !== undefined) {
      setOriginalWindowParameters(undefined);
      setWindowParameters(undefined);
    }
  }, [isBrushCleared, originalWindowParameters]);
  function onWindowParametersChange(wp, wpPx) {
    if (brushSelectionUpdateHandler === undefined) {
      return;
    }
    setWindowParameters(wp);
    setWindowParametersAsPixels(wpPx);
    brushSelectionUpdateHandler(wp, false);
  }
  const [mlBrushWidth, setMlBrushWidth] = (0, _react.useState)();
  const [mlBrushMarginLeft, setMlBrushMarginLeft] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (viewMode !== VIEW_MODE.BRUSH) {
      setOriginalWindowParameters(undefined);
      setWindowParameters(undefined);
    }
  }, [viewMode]);
  const isBrushVisible = originalWindowParameters && windowParameters && mlBrushMarginLeft && mlBrushWidth && mlBrushWidth > 0;

  // Avoid overlap of brush badges when the brushes are quite narrow.
  const baselineBadgeOverflow = windowParametersAsPixels ? getBaselineBadgeOverflow(windowParametersAsPixels, BADGE_WIDTH) : 0;
  const baselineBadgeMarginLeft = (mlBrushMarginLeft !== null && mlBrushMarginLeft !== void 0 ? mlBrushMarginLeft : 0) + ((_windowParametersAsPi = windowParametersAsPixels === null || windowParametersAsPixels === void 0 ? void 0 : windowParametersAsPixels.baselineMin) !== null && _windowParametersAsPi !== void 0 ? _windowParametersAsPi : 0);
  const barColor = barColorOverride ? [barColorOverride] : undefined;
  const barHighlightColor = barHighlightColorOverride ? [barHighlightColorOverride] : ['orange'];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isBrushVisible && /*#__PURE__*/_react.default.createElement("div", {
    className: "aiopsHistogramBrushes",
    "data-test-subj": "aiopsHistogramBrushes"
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      height: BADGE_HEIGHT
    }
  }, /*#__PURE__*/_react.default.createElement(_brush_badge.BrushBadge, {
    label: _i18n.i18n.translate('xpack.aiops.documentCountChart.baselineBadgeLabel', {
      defaultMessage: 'Baseline'
    }),
    marginLeft: baselineBadgeMarginLeft - baselineBadgeOverflow,
    timestampFrom: windowParameters.baselineMin,
    timestampTo: windowParameters.baselineMax,
    width: BADGE_WIDTH
  }), /*#__PURE__*/_react.default.createElement(_brush_badge.BrushBadge, {
    label: _i18n.i18n.translate('xpack.aiops.documentCountChart.deviationBadgeLabel', {
      defaultMessage: 'Deviation'
    }),
    marginLeft: mlBrushMarginLeft + ((_windowParametersAsPi2 = windowParametersAsPixels === null || windowParametersAsPixels === void 0 ? void 0 : windowParametersAsPixels.deviationMin) !== null && _windowParametersAsPi2 !== void 0 ? _windowParametersAsPi2 : 0),
    timestampFrom: windowParameters.deviationMin,
    timestampTo: windowParameters.deviationMax,
    width: BADGE_WIDTH
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      'margin-bottom': '-4px'
    }
  }, /*#__PURE__*/_react.default.createElement(_aiopsComponents.DualBrush, {
    windowParameters: originalWindowParameters,
    min: timeRangeEarliest,
    max: timeRangeLatest + interval,
    onChange: onWindowParametersChange,
    marginLeft: mlBrushMarginLeft,
    snapTimestamps: snapTimestamps,
    width: mlBrushWidth
  }))), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: width !== null && width !== void 0 ? width : '100%'
    },
    "data-test-subj": "aiopsDocumentCountChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: '100%',
      height: 120
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: viewMode !== VIEW_MODE.BRUSH ? onBrushEnd : undefined,
    onElementClick: onElementClick,
    onProjectionAreaChange: ({
      projection
    }) => {
      setMlBrushMarginLeft(projection.left);
      setMlBrushWidth(projection.width);
    },
    theme: chartTheme,
    baseTheme: chartBaseTheme,
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    showLegend: false,
    showLegendExtra: false
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "aiops-histogram-left-axis",
    position: _charts.Position.Left,
    ticks: 2,
    integersOnly: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "aiops-histogram-bottom-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: value => xAxisFormatter.convert(value),
    labelFormat: useLegacyTimeAxis ? undefined : () => '',
    timeAxisLayerCount: useLegacyTimeAxis ? 0 : 2,
    style: useLegacyTimeAxis ? {} : _common.MULTILAYER_TIME_AXIS_STYLE
  }), (adjustedChartPoints === null || adjustedChartPoints === void 0 ? void 0 : adjustedChartPoints.length) && /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: SPEC_ID,
    name: chartPointsSplit ? overallSeriesNameWithSplit : overallSeriesName,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "time",
    yAccessors: ['value'],
    data: adjustedChartPoints,
    timeZone: timeZone,
    color: barColor,
    yNice: true
  }), (adjustedChartPointsSplit === null || adjustedChartPointsSplit === void 0 ? void 0 : adjustedChartPointsSplit.length) && /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: `${SPEC_ID}_split`,
    name: chartPointsSplitLabel,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "time",
    yAccessors: ['value'],
    data: adjustedChartPointsSplit,
    timeZone: timeZone,
    color: barHighlightColor,
    yNice: true
  }), windowParameters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_aiopsComponents.DualBrushAnnotation, {
    id: "aiopsBaseline",
    min: windowParameters.baselineMin,
    max: windowParameters.baselineMax
  }), /*#__PURE__*/_react.default.createElement(_aiopsComponents.DualBrushAnnotation, {
    id: "aiopsDeviation",
    min: windowParameters.deviationMin,
    max: windowParameters.deviationMax
  })))));
};
exports.DocumentCountChart = DocumentCountChart;