"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _change_point_detection_context = require("./change_point_detection_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SplitFieldSelector = /*#__PURE__*/_react.default.memo(({
  value,
  onChange
}) => {
  const {
    fieldStats
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    renderOption,
    closeFlyout
  } = fieldStats.useFieldStatsTrigger();
  const {
    splitFieldsOptions
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const options = (0, _react.useMemo)(() => {
    return [{
      value: undefined,
      label: _i18n.i18n.translate('xpack.aiops.changePointDetection.notSelectedSplitFieldLabel', {
        defaultMessage: '--- Not selected ---'
      })
    }, ...splitFieldsOptions.map(v => ({
      value: v.name,
      label: v.displayName,
      ...(v.name ? {
        field: {
          id: v.name,
          type: v === null || v === void 0 ? void 0 : v.type
        }
      } : {})
    }))];
  }, [splitFieldsOptions]);
  const selection = options.filter(v => v.value === value);
  const onChangeCallback = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    const newValue = option === null || option === void 0 ? void 0 : option.value;
    onChange(newValue);
    closeFlyout();
  }, [onChange, closeFlyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.aiops.changePointDetection.selectSpitFieldLabel', {
      defaultMessage: 'Split field'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChangeCallback,
    isClearable: true,
    "data-test-subj": "aiopsChangePointSplitField"
    // @ts-ignore
    ,
    renderOption: renderOption
  }));
});
exports.SplitFieldSelector = SplitFieldSelector;