"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAriaName = getAriaName;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _search = require("../components/search/search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mapWords = name => (0, _lodash.words)(name !== null && name !== void 0 ? name : '').map(word => word.toLowerCase()).join(' ');

/**
 * @name {string} the name of the configuration object
 * @returns {string} a space delimited, lowercase string with
 *          special characters removed.
 *
 * Examples:
 * - `xPack:fooBar:foo_bar_baz` -> `x pack foo bar foo bar baz`
 * - `xPack:fooBar:foo_bar_baz category:(general)` -> `x pack foo bar foo bar baz category:(general)`
 */
function getAriaName(name) {
  if (!name) {
    return '';
  }
  const query = _eui.Query.parse(name);
  if (query.hasOrFieldClause(_search.CATEGORY_FIELD)) {
    const categories = query.getOrFieldClause(_search.CATEGORY_FIELD);
    const termValue = mapWords(query.removeOrFieldClauses(_search.CATEGORY_FIELD).text);
    if (!categories || !Array.isArray(categories.value)) {
      return termValue;
    }
    let categoriesQuery = _eui.Query.parse('');
    categories.value.forEach(v => {
      categoriesQuery = categoriesQuery.addOrFieldValue(_search.CATEGORY_FIELD, v);
    });
    return `${termValue} ${categoriesQuery.text}`;
  }
  return mapWords(name);
}