"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsecuredActionsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOTIFICATION_REQUESTER_ID = 'notifications';

// allowlist for features wanting access to the unsecured actions client
// which allows actions to be enqueued for execution without a user request
const ALLOWED_REQUESTER_IDS = [NOTIFICATION_REQUESTER_ID,
// For functional testing
'functional_tester'];
class UnsecuredActionsClient {
  constructor(params) {
    (0, _defineProperty2.default)(this, "internalSavedObjectsRepository", void 0);
    (0, _defineProperty2.default)(this, "executionEnqueuer", void 0);
    this.executionEnqueuer = params.executionEnqueuer;
    this.internalSavedObjectsRepository = params.internalSavedObjectsRepository;
  }
  async bulkEnqueueExecution(requesterId, actionsToExecute) {
    // Check that requesterId is allowed
    if (!ALLOWED_REQUESTER_IDS.includes(requesterId)) {
      throw new Error(`"${requesterId}" feature is not allow-listed for UnsecuredActionsClient access.`);
    }
    // Inject source based on requesterId
    return this.executionEnqueuer(this.internalSavedObjectsRepository, this.injectSource(requesterId, actionsToExecute));
  }
  injectSource(requesterId, actionsToExecute) {
    switch (requesterId) {
      case NOTIFICATION_REQUESTER_ID:
        return actionsToExecute.map(actionToExecute => ({
          ...actionToExecute,
          source: (0, _lib.asNotificationExecutionSource)({
            requesterId,
            connectorId: actionToExecute.id
          })
        }));
      default:
        return actionsToExecute;
    }
  }
}
exports.UnsecuredActionsClient = UnsecuredActionsClient;