"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTabStyles = exports.euiTabContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _title = require("../title/title.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "10tso78-expanded",
  styles: "flex-basis:0%;flex-grow:1;justify-content:center;label:expanded;"
} : {
  name: "10tso78-expanded",
  styles: "flex-basis:0%;flex-grow:1;justify-content:center;label:expanded;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTabStyles = function euiTabStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiTab: /*#__PURE__*/(0, _react.css)("display:flex;cursor:pointer;flex-direction:row;align-items:center;font-weight:", euiTheme.font.weight.semiBold, ";gap:", euiTheme.size.s, ";", (0, _global_styling.logicalCSS)('padding-vertical', 0), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), " &:focus{background-color:transparent;outline-offset:-", euiTheme.focus.width, ";};label:euiTab;"),
    // variations
    expanded: _ref2,
    selected: /*#__PURE__*/(0, _react.css)("box-shadow:inset 0 -", euiTheme.border.width.thick, " 0 ", euiTheme.colors.primary, ";;label:selected;"),
    disabled: {
      disabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;color:", euiTheme.colors.disabledText, ";;label:disabled;"),
      selected: /*#__PURE__*/(0, _react.css)("box-shadow:inset 0 -", euiTheme.border.width.thick, " 0 ", euiTheme.colors.disabledText, ";;label:selected;")
    }
  };
};
exports.euiTabStyles = euiTabStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1yhgei9-euiTab__content",
  styles: "&:hover{text-decoration:none;};label:euiTab__content;"
} : {
  name: "1yhgei9-euiTab__content",
  styles: "&:hover{text-decoration:none;};label:euiTab__content;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTabContentStyles = function euiTabContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiTab__content: _ref,
    // sizes
    s: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxxs'), ";line-height:", euiTheme.size.xl, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxs'), ";line-height:", euiTheme.size.xxl, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), ";line-height:", (0, _global_styling.mathWithUnits)([euiTheme.size.xl, euiTheme.size.s], function (x, y) {
      return x + y;
    }), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 's'), ";line-height:", (0, _global_styling.mathWithUnits)([euiTheme.size.xxxl, euiTheme.size.s], function (x, y) {
      return x + y;
    }), ";;label:xl;"),
    // variations
    selected: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:selected;"),
    disabled: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.disabledText, ";;label:disabled;")
  };
};
exports.euiTabContentStyles = euiTabContentStyles;