"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _tab = require("./tab.styles");
var _tabs_context = require("./tabs_context");
var _react2 = require("@emotion/react");
var _excluded = ["isSelected", "children", "className", "disabled", "href", "target", "rel", "prepend", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiTab = function EuiTab(_ref) {
  var isSelected = _ref.isSelected,
    children = _ref.children,
    className = _ref.className,
    _disabled = _ref.disabled,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    prepend = _ref.prepend,
    append = _ref.append,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_tabs_context.EuiTabsContext),
    size = _useContext.size,
    expand = _useContext.expand;
  var euiTheme = (0, _services.useEuiTheme)();
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var disabled = _disabled || !isHrefValid;

  // Keep CSS classnames for reference
  var classes = (0, _classnames.default)('euiTab', className, {
    'euiTab-isSelected': isSelected
  });
  var tabStyles = (0, _tab.euiTabStyles)(euiTheme);
  var cssTabStyles = [tabStyles.euiTab, expand && tabStyles.expanded, disabled && tabStyles.disabled.disabled, isSelected && (disabled ? tabStyles.disabled.selected : tabStyles.selected)];
  var tabContentStyles = (0, _tab.euiTabContentStyles)(euiTheme);
  var cssTabContentStyles = [tabContentStyles.euiTab__content, size && tabContentStyles[size], isSelected && tabContentStyles.selected, disabled && tabContentStyles.disabled];
  var prependNode = prepend && (0, _react2.jsx)("span", {
    className: "euiTab__prepend"
  }, prepend);
  var appendNode = append && (0, _react2.jsx)("span", {
    className: "euiTab__append"
  }, append);

  //  <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  //  this is a button and piggyback off its disabled styles.
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    return (0, _react2.jsx)("a", _extends({
      role: "tab",
      "aria-selected": !!isSelected,
      className: classes,
      css: cssTabStyles,
      href: href,
      target: target,
      rel: secureRel
    }, rest), prependNode, (0, _react2.jsx)("span", {
      className: "euiTab__content",
      css: cssTabContentStyles
    }, children), appendNode);
  }
  return (0, _react2.jsx)("button", _extends({
    role: "tab",
    "aria-selected": !!isSelected,
    type: "button",
    className: classes,
    css: cssTabStyles,
    disabled: disabled
  }, rest), prependNode, (0, _react2.jsx)("span", {
    className: "euiTab__content",
    css: cssTabContentStyles
  }, children), appendNode);
};
exports.EuiTab = EuiTab;
EuiTab.propTypes = {
  isSelected: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  /**
     * Places content before the tab content/children.
     * Will be excluded from interactive effects.
     */
  /**
     * Places content before the tab content/children.
     * Will be excluded from interactive effects.
     */
  prepend: _propTypes.default.node,
  /**
     * Places content after the tab content/children.
     * Will be excluded from interactive effects.
     */
  /**
     * Places content after the tab content/children.
     * Will be excluded from interactive effects.
     */
  append: _propTypes.default.node,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  href: _propTypes.default.string,
  onClick: _propTypes.default.func
};