"use strict";

var _react = _interopRequireDefault(require("react"));
var _form = require("../form");
var _suggest = require("./suggest");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Suggest = function Suggest() {
  var suggestedItems = [{
    type: {
      iconType: 'accessibility',
      color: 'tint1'
    },
    label: 'Accessibility',
    description: 'A short description'
  }, {
    type: {
      iconType: 'image',
      color: 'tint2'
    },
    label: 'Images',
    description: 'Another short description'
  }, {
    type: {
      iconType: 'lock',
      color: 'tint3'
    },
    label: 'Locks',
    description: 'A third short description'
  }];
  return (0, _react2.jsx)(_form.EuiFormRow, {
    label: "Suggest a topic",
    id: "cy-label-suggest-1"
  }, (0, _react2.jsx)(_suggest.EuiSuggest, {
    "aria-labelledby": "cy-label-suggest-1-label",
    suggestions: suggestedItems
  }));
};
describe('EuiSuggest', function () {
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(Suggest, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing list items', function () {
      cy.realPress('Tab');
      cy.get('#cy-label-suggest-1').should('have.focus');
      cy.get('ul[role="listbox"]').should('exist');
      cy.realPress('ArrowDown');
      cy.realPress('ArrowUp');
      cy.realPress('ArrowRight');
      cy.realPress('ArrowLeft');
      cy.get('li[role="option"]').first().should('have.attr', 'aria-selected', 'true');
      cy.checkAxe();
    });
  });
});