"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableTemplateSitewide = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _selectable = require("../selectable");
var _popover = require("../../popover");
var _popover2 = require("../../popover/popover");
var _i18n = require("../../i18n");
var _selectable_message = require("../selectable_message");
var _loading = require("../../loading");
var _selectable_template_sitewide_option = require("./selectable_template_sitewide_option");
var _spacer = require("../../spacer");
var _keys = require("../../../services/keys");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "options", "popoverProps", "popoverTitle", "popoverFooter", "searchProps", "listProps", "isLoading", "popoverButton", "popoverButtonBreakpoints"],
  _excluded2 = ["closePopover", "panelRef", "width"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiSelectableTemplateSitewide = function EuiSelectableTemplateSitewide(_ref) {
  var children = _ref.children,
    className = _ref.className,
    options = _ref.options,
    popoverProps = _ref.popoverProps,
    popoverTitle = _ref.popoverTitle,
    popoverFooter = _ref.popoverFooter,
    searchProps = _ref.searchProps,
    listProps = _ref.listProps,
    isLoading = _ref.isLoading,
    popoverButton = _ref.popoverButton,
    popoverButtonBreakpoints = _ref.popoverButtonBreakpoints,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * i18n text
   */
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiSelectableTemplateSitewide.searchPlaceholder'], ['Search for anything...']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 1),
    searchPlaceholder = _useEuiI18n2[0];

  /**
   * Popover helpers
   */
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    popoverRef = _useState2[0],
    setPopoverRef = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    popoverIsOpen = _useState4[0],
    setPopoverIsOpen = _useState4[1];
  var _popoverProps = _objectSpread({}, popoverProps),
    _closePopover = _popoverProps.closePopover,
    panelRef = _popoverProps.panelRef,
    width = _popoverProps.width,
    popoverRest = _objectWithoutProperties(_popoverProps, _excluded2);
  var closePopover = function closePopover() {
    setPopoverIsOpen(false);
    _closePopover && _closePopover();
  };
  var togglePopover = function togglePopover() {
    setPopoverIsOpen(!popoverIsOpen);
  };

  // Width applied to the internal div
  var popoverWidth = width || 600;
  var setPanelRef = (0, _services.useCombinedRefs)([setPopoverRef, panelRef]);

  /**
   * Search helpers
   */
  var searchOnFocus = function searchOnFocus(e) {
    var _searchProps$onFocus;
    searchProps === null || searchProps === void 0 ? void 0 : (_searchProps$onFocus = searchProps.onFocus) === null || _searchProps$onFocus === void 0 ? void 0 : _searchProps$onFocus.call(searchProps, e);
    setPopoverIsOpen(true);
  };
  var onSearchInput = function onSearchInput(e) {
    var _searchProps$onInput;
    searchProps === null || searchProps === void 0 ? void 0 : (_searchProps$onInput = searchProps.onInput) === null || _searchProps$onInput === void 0 ? void 0 : _searchProps$onInput.call(searchProps, e);
    setPopoverIsOpen(true);
  };
  var onSearchKeydown = function onSearchKeydown(e) {
    var _searchProps$onKeyDow;
    searchProps === null || searchProps === void 0 ? void 0 : (_searchProps$onKeyDow = searchProps.onKeyDown) === null || _searchProps$onKeyDow === void 0 ? void 0 : _searchProps$onKeyDow.call(searchProps, e);
    if (e.key === _keys.ENTER) {
      setPopoverIsOpen(true);
    }
  };
  var searchOnBlur = function searchOnBlur(e) {
    var _searchProps$onBlur;
    searchProps === null || searchProps === void 0 ? void 0 : (_searchProps$onBlur = searchProps.onBlur) === null || _searchProps$onBlur === void 0 ? void 0 : _searchProps$onBlur.call(searchProps, e);
    if (!(popoverRef !== null && popoverRef !== void 0 && popoverRef.contains(e.relatedTarget))) {
      setPopoverIsOpen(false);
    }
  };

  /**
   * Classes
   */
  var classes = (0, _classnames.default)('euiSelectableTemplateSitewide', className);
  var searchClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__search', searchProps && searchProps.className);
  var listClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__list', listProps && listProps.className);

  /**
   * List options
   */
  var formattedOptions = (0, _selectable_template_sitewide_option.euiSelectableTemplateSitewideFormatOptions)(options);
  var loadingMessage = (0, _react2.jsx)(_selectable_message.EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
    size: "l"
  }), (0, _react2.jsx)("br", null), (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiSelectableTemplateSitewide.loadingResults",
    default: "Loading results"
  })));
  var emptyMessage = (0, _react2.jsx)(_selectable_message.EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiSelectableTemplateSitewide.noResults",
    default: "No results available"
  })));

  /**
   * Changes based on showing the `popoverButton` if provided.
   * This will move the search input into the popover
   * and use the passed `popoverButton` as the popover trigger.
   */
  var currentBreakpoint = (0, _services.useCurrentEuiBreakpoint)();
  var canShowPopoverButton = (0, _react.useMemo)(function () {
    if (!popoverButtonBreakpoints) return true;
    if (!currentBreakpoint) return false;
    return popoverButtonBreakpoints.includes(currentBreakpoint);
  }, [currentBreakpoint, popoverButtonBreakpoints]);
  var popoverTrigger;
  if (popoverButton && canShowPopoverButton) {
    popoverTrigger = /*#__PURE__*/_react.default.cloneElement(popoverButton, _objectSpread(_objectSpread({}, popoverButton.props), {}, {
      onClick: togglePopover,
      onKeyDown: function onKeyDown(e) {
        // Selectable preventsDefault on Enter which kills browser controls for pressing the button
        e.stopPropagation();
      }
    }));
  }
  return (0, _react2.jsx)(_selectable.EuiSelectable, _extends({
    isLoading: isLoading,
    options: formattedOptions,
    renderOption: _selectable_template_sitewide_option.euiSelectableTemplateSitewideRenderOptions,
    singleSelection: true,
    searchProps: _objectSpread(_objectSpread({
      placeholder: searchPlaceholder,
      isClearable: true
    }, searchProps), {}, {
      onFocus: searchOnFocus,
      onBlur: searchOnBlur,
      onInput: onSearchInput,
      onKeyDown: onSearchKeydown,
      className: searchClasses
    }),
    listProps: _objectSpread(_objectSpread({
      rowHeight: 68,
      showIcons: false,
      onFocusBadge: {
        iconSide: 'right',
        children: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableTemplateSitewide.onFocusBadgeGoTo",
          default: "Go to"
        })
      }
    }, listProps), {}, {
      className: listClasses
    }),
    loadingMessage: loadingMessage,
    emptyMessage: emptyMessage,
    noMatchesMessage: emptyMessage
  }, rest, {
    className: classes,
    searchable: true
  }), function (list, search) {
    return (0, _react2.jsx)(_popover2.EuiPopover, _extends({
      panelPaddingSize: "none",
      isOpen: popoverIsOpen,
      ownFocus: !!popoverTrigger,
      display: popoverTrigger ? 'inline-block' : 'block'
    }, popoverRest, {
      panelRef: setPanelRef,
      button: popoverTrigger ? popoverTrigger : search,
      closePopover: closePopover
    }), (0, _react2.jsx)("div", {
      style: {
        width: popoverWidth,
        maxWidth: '100%'
      }
    }, popoverTitle || popoverTrigger ? (0, _react2.jsx)(_popover.EuiPopoverTitle, {
      paddingSize: "s"
    }, popoverTitle, popoverTitle && search && (0, _react2.jsx)(_spacer.EuiSpacer, null), search) : undefined, list, popoverFooter && (0, _react2.jsx)(_popover.EuiPopoverFooter, {
      paddingSize: "s"
    }, popoverFooter)));
  });
};
exports.EuiSelectableTemplateSitewide = EuiSelectableTemplateSitewide;
EuiSelectableTemplateSitewide.propTypes = {
  /**
     * Extends the typical EuiSelectable #Options with the addition of pre-composed elements
     * such as `icon`, `avatar`and `meta`
     */
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Displayed on the left (`prepend`).
       * Object of `EuiIconProps` for display of the solution/application's logo
       */
    icon: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      /**
           * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
           * Note that coloring only works if your SVG is removed of fill attributes.
           */
      color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.any.isRequired]),
      /**
           * Descriptive title for naming the icon based on its use
           */
      title: _propTypes.default.string,
      /**
           * A unique identifier for the title element
           */
      titleId: _propTypes.default.string,
      /**
           * Its value should be one or more element IDs
           */
      "aria-labelledby": _propTypes.default.string,
      /**
           * Callback when the icon has been loaded & rendered
           */
      onIconLoad: _propTypes.default.func
    }),
    /**
       * Displayed on the right (`append`).
       * Object of `EuiAvatarProps` for display of the space (default) or user
       */
    avatar: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      /**
             * Custom initials (max 2 characters).
             * By default will take the first character (of each word).
             */
      initials: _propTypes.default.string,
      /**
             * Specify how many characters to show (1 or 2).
             * By default, will show based on number of words (max first 2).
             */
      initialsLength: _propTypes.default.oneOf([1, 2]),
      /**
             * Path to an image to display instead of initials
             */
      imageUrl: _propTypes.default.string,
      /**
           * Any EUI glyph, logo or custom icon to display instead of initials
           */
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "error", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDenseVector", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
      /**
           * Manually change icon size
           */
      iconSize: _propTypes.default.any,
      /**
           * Manually change icon color
           */
      iconColor: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.any.isRequired]).isRequired, _propTypes.default.oneOf([null])]),
      /**
           * Full name of avatar for title attribute and calculating initial if not provided
           */
      name: _propTypes.default.string.isRequired,
      /**
           * Accepts hex values like `#FFFFFF`, `#000` otherwise a viz palette color will be assigned.
           * Or pass `'plain'` for an empty shade, `'subdued'` for a light gray shade or `null` to remove entirely and the text/icon color will `inherit`
           */
      color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf(["plain", "subdued", null])]),
      /**
           * The type of avatar mainly controlling the shape.
           * `user` = circle
           * `space` = rounded square
           */
      type: _propTypes.default.any,
      size: _propTypes.default.any,
      /**
           * Sets the letter casing of the displayed initials.
           * Defaults to `uppercase` for `type="user"` avatars.
           * Defaults to `none` (uses the existing casing of the passed `name` or `initials`) for `type="space"` avatars.
           * @default uppercase
           */
      casing: _propTypes.default.any,
      /**
           * Grays out the avatar to simulate being disabled
           */
      isDisabled: _propTypes.default.bool
    }),
    /**
       * An array of inline #MetaData displayed beneath the label and separated by bullets.
       */
    meta: _propTypes.default.arrayOf(_propTypes.default.shape({
      /**
         * Required to display the metadata
         */
      text: _propTypes.default.string.isRequired,
      /**
         * Styles the metadata according to Elastic's schema.
         * Can be one of 'application', 'deployment', 'article', 'case', 'platform',
         * or a custom string to associate with your own schema.
         * Appends the string to the class name as `euiSelectableTemplateSitewide__optionMeta--[type]`
         */
      type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["application", "deployment", "article", "case", "platform"]), _propTypes.default.string.isRequired]),
      /**
         * Will wrap the meta tag in EuiHighlight to mark the portions that match the search text
         */
      highlightSearchString: _propTypes.default.bool,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }).isRequired),
    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: _propTypes.default.string,
    /**
       * Optionally change the searchable term by passing a different string other than the `label`.
       * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
       */
    searchableLabel: _propTypes.default.string,
    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: _propTypes.default.string,
    /**
       * Leave `undefined` to indicate not selected. Pass a string of
       * 'on' to indicate inclusion, 'off' to indicate exclusion,
       * or 'mixed' to indicate inclusion for some.
       */
    checked: _propTypes.default.oneOf(["on", "off", "mixed", undefined]),
    disabled: _propTypes.default.bool,
    /**
       * Node to add between the selection icon and the label
       */
    prepend: _propTypes.default.node,
    /**
       * Node to add to the far right of the item
       */
    append: _propTypes.default.node,
    ref: _propTypes.default.func,
    /**
       * Option data to pass through to the `renderOptions` element.
       * Bypass `EuiSelectableItem` and avoid DOM attribute warnings.
       */
    data: _propTypes.default.shape({})
  }).isRequired).isRequired,
  /**
     * Override some of the EuiPopover props housing the list.
     * The default width is `600`
     */
  popoverProps: _propTypes.default.shape({
    width: _propTypes.default.any
  }),
  /**
     * Optionally provide a title for the popover
     */
  popoverTitle: _propTypes.default.node,
  /**
     * Optionally provide a footer for the popover
     */
  popoverFooter: _propTypes.default.node,
  /**
     * Optionally provide a separate button for toggling the display of the popover.
     */
  popoverButton: _propTypes.default.element,
  /**
     * Pass an array of named breakpoints for which to show the `popoverButton`.
     * If `undefined`, the `popoverButton` will always show (if provided)
     */
  popoverButtonBreakpoints: _propTypes.default.arrayOf(_propTypes.default.any.isRequired)
};