"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("../basic_table");
var _flex = require("../flex");
var _health = require("../health");
var _spacer = require("../spacer");
var _search_bar = require("./search_bar");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var tags = [{
  name: 'marketing',
  color: 'danger'
}, {
  name: 'finance',
  color: 'success'
}, {
  name: 'eng',
  color: 'success'
}, {
  name: 'sales',
  color: 'warning'
}, {
  name: 'ga',
  color: 'success'
}];
var tagsMap = tags.map(function (tag) {
  return {
    value: tag.name,
    view: (0, _react2.jsx)(_health.EuiHealth, {
      color: tag.color
    }, tag.name)
  };
});
var items = [{
  type: 'Dashboard',
  id: 1,
  status: 'Open',
  tag: ['finance', 'sales', 'marketing'],
  owner: 'Dewey'
}, {
  type: 'Visualization',
  id: 2,
  status: 'Open',
  tag: ['finance'],
  owner: 'Wanda'
}, {
  type: 'Dashboard',
  id: 3,
  status: 'Closed',
  tag: ['eng'],
  owner: 'Carrie'
}, {
  type: 'Watch',
  id: 4,
  status: 'Open',
  tag: ['sales', 'ga'],
  owner: 'Dewey'
}, {
  type: 'Dashboard',
  id: 5,
  status: 'Closed',
  tag: ['finance'],
  owner: 'Carrie'
}];
var SearchBar = function SearchBar() {
  var _useState = (0, _react.useState)(''),
    _useState2 = _slicedToArray(_useState, 2),
    query = _useState2[0],
    setQuery = _useState2[1];
  var renderSearch = function renderSearch() {
    var filters = [{
      type: 'field_value_toggle_group',
      field: 'status',
      items: [{
        value: 'open',
        name: 'Open'
      }, {
        value: 'closed',
        name: 'Closed'
      }]
    }, {
      type: 'field_value_selection',
      field: 'tag',
      name: 'Tag',
      multiSelect: 'or',
      options: tagsMap
    }];
    var schema = {
      strict: true,
      fields: {
        type: {
          type: 'string'
        },
        status: {
          type: 'string'
        },
        created: {
          type: 'date'
        },
        owner: {
          type: 'string'
        },
        tag: {
          type: 'string'
        }
      }
    };
    return (0, _react2.jsx)(_search_bar.EuiSearchBar, {
      query: query,
      box: {
        placeholder: 'type:visualization',
        schema: schema
      },
      filters: filters,
      onChange: function onChange(_ref) {
        var query = _ref.query;
        if (query) setQuery(query);
      }
    });
  };
  var renderTable = function renderTable() {
    var columns = [{
      name: 'Type',
      field: 'type'
    }, {
      name: 'Owner',
      field: 'owner'
    }, {
      name: 'Open',
      field: 'status'
    }, {
      name: 'Tags',
      field: 'tag'
    }];
    var queriedItems = _search_bar.EuiSearchBar.Query.execute(query, items, {
      defaultFields: ['owner', 'tag', 'type']
    });
    return (0, _react2.jsx)(_basic_table.EuiBasicTable, {
      items: queriedItems,
      columns: columns
    });
  };
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    alignItems: "center"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, renderSearch())), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "l"
  }), (0, _react2.jsx)(_flex.EuiFlexGroup, null, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: 6
  }, renderTable())));
};
exports.SearchBar = SearchBar;
describe('EuiSearchBar', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(SearchBar, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after a full-text search', function () {
      cy.realPress('Tab');
      cy.get('input[type="search"]').should('have.focus');
      cy.get('input[type="search"]').type('watch');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 1);
      cy.checkAxe();
      cy.realPress('Tab');
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
    it('has zero violations after filtering on Open items', function () {
      cy.repeatRealPress('Tab');
      cy.get('button.euiButtonEmpty').first().should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 3);
      cy.checkAxe();
      cy.realPress(['Shift', 'Tab']);
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
    it('has zero violations after filtering by Tags', function () {
      cy.repeatRealPress('Tab', 4);
      cy.get('button.euiButtonEmpty').last().should('have.focus');
      cy.realPress('Enter');
      cy.realPress('Tab');
      cy.realPress('ArrowDown');
      cy.realPress('Enter');
      cy.realPress('Escape');
      cy.get('button.euiButtonEmpty').last().should('have.focus');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 3);
      cy.checkAxe();
      cy.repeatRealPress(['Shift', 'Tab'], 3);
      cy.get('button[data-test-subj="clearSearchButton"]').should('have.focus');
      cy.realPress('Enter');
      cy.get('table.euiTable tbody').find('tr').should('have.length', 5);
      cy.checkAxe();
    });
  });
});